/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Creates a page transition animation for a PDF full screen presentation. It is possible to specify several transition elements for different page ranges.")
@JsonPropertyOrder(value={"autoScroll", "autoScrollTime", "direction", "duration", "flyAreaOpaque", "flyScale", "pages", "style"})
@JsonTypeName(value="Operation_Transition")
public class OperationTransition {
    public static final String JSON_PROPERTY_AUTO_SCROLL = "autoScroll";
    private Boolean autoScroll = false;
    public static final String JSON_PROPERTY_AUTO_SCROLL_TIME = "autoScrollTime";
    private Float autoScrollTime = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction = DirectionEnum.NONE;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Float duration = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_FLY_AREA_OPAQUE = "flyAreaOpaque";
    private Boolean flyAreaOpaque = false;
    public static final String JSON_PROPERTY_FLY_SCALE = "flyScale";
    private Float flyScale = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_STYLE = "style";
    private StyleEnum style = StyleEnum.NONE;

    public OperationTransition autoScroll(Boolean autoScroll) {
        this.autoScroll = autoScroll;
        return this;
    }

    @Schema(name="If true, the next page to be automatically shown completely in full screen presentation mode after a specific time.")
    @JsonProperty(value="autoScroll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAutoScroll() {
        return this.autoScroll;
    }

    @JsonProperty(value="autoScroll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoScroll(Boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public OperationTransition autoScrollTime(Float autoScrollTime) {
        this.autoScrollTime = autoScrollTime;
        return this;
    }

    @Schema(name="The time it will take for the next page to be automatically shown completely in full screen presentation mode.")
    @JsonProperty(value="autoScrollTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getAutoScrollTime() {
        return this.autoScrollTime;
    }

    @JsonProperty(value="autoScrollTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoScrollTime(Float autoScrollTime) {
        this.autoScrollTime = autoScrollTime;
    }

    public OperationTransition direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Schema(name="The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight = From left to right *   bottomToTop = From bottom to top *   rightToLeft = From right to left *   topToBottom = From top to bottom *   topLeftToBottomRight = From top left to bottom right *   none = Use the default value for the animation")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public OperationTransition duration(Float duration) {
        this.duration = duration;
        return this;
    }

    @Schema(name="The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommendable.")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public OperationTransition flyAreaOpaque(Boolean flyAreaOpaque) {
        this.flyAreaOpaque = flyAreaOpaque;
        return this;
    }

    @Schema(name="Option for the \"fly\" animation style - used to define whether the page background for the page that flies in should be transparent initially.")
    @JsonProperty(value="flyAreaOpaque")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFlyAreaOpaque() {
        return this.flyAreaOpaque;
    }

    @JsonProperty(value="flyAreaOpaque")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlyAreaOpaque(Boolean flyAreaOpaque) {
        this.flyAreaOpaque = flyAreaOpaque;
    }

    public OperationTransition flyScale(Float flyScale) {
        this.flyScale = flyScale;
        return this;
    }

    @Schema(name="Option for the \"fly\" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed.")
    @JsonProperty(value="flyScale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getFlyScale() {
        return this.flyScale;
    }

    @JsonProperty(value="flyScale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlyScale(Float flyScale) {
        this.flyScale = flyScale;
    }

    public OperationTransition pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Used to define the page number or page range (e.g., \"1,5-6,9\") to which the transition animation should be applied.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationTransition style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @Schema(name="The style of transition animation.  *   blinds = Crossfades *   box = Crossfades in a rectangular pattern *   cover = Covers *   dissolve = Dissolves *   fade = Fades *   fly = Page flies in *   glitter = Page dissolves and is replaced *   push = Page is pushed out *   split = Splits page *   uncover = Uncovers page *   wipe = Wipes page *   none = No special effect")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public StyleEnum getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTransition operationTransition = (OperationTransition)o;
        return Objects.equals(this.autoScroll, operationTransition.autoScroll) && Objects.equals(this.autoScrollTime, operationTransition.autoScrollTime) && Objects.equals((Object)this.direction, (Object)operationTransition.direction) && Objects.equals(this.duration, operationTransition.duration) && Objects.equals(this.flyAreaOpaque, operationTransition.flyAreaOpaque) && Objects.equals(this.flyScale, operationTransition.flyScale) && Objects.equals(this.pages, operationTransition.pages) && Objects.equals((Object)this.style, (Object)operationTransition.style);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoScroll, this.autoScrollTime, this.direction, this.duration, this.flyAreaOpaque, this.flyScale, this.pages, this.style});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTransition {\n");
        sb.append("    autoScroll: ").append(this.toIndentedString(this.autoScroll)).append("\n");
        sb.append("    autoScrollTime: ").append(this.toIndentedString(this.autoScrollTime)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    flyAreaOpaque: ").append(this.toIndentedString(this.flyAreaOpaque)).append("\n");
        sb.append("    flyScale: ").append(this.toIndentedString(this.flyScale)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StyleEnum {
        BLINDS(String.valueOf("blinds")),
        BOX(String.valueOf("box")),
        COVER(String.valueOf("cover")),
        DISSOLVE(String.valueOf("dissolve")),
        FADE(String.valueOf("fade")),
        FLY(String.valueOf("fly")),
        GLITTER(String.valueOf("glitter")),
        PUSH(String.valueOf("push")),
        SPLIT(String.valueOf("split")),
        UNCOVER(String.valueOf("uncover")),
        WIPE(String.valueOf("wipe")),
        NONE(String.valueOf("none"));

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DirectionEnum {
        LEFT_TO_RIGHT(String.valueOf("leftToRight")),
        BOTTOM_TO_TOP(String.valueOf("bottomToTop")),
        RIGHT_TO_LEFT(String.valueOf("rightToLeft")),
        TOP_TO_BOTTOM(String.valueOf("topToBottom")),
        TOP_LEFT_TO_BOTTOM_RIGHT(String.valueOf("topLeftToBottomRight")),
        NONE(String.valueOf("none"));

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

