/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationHtmlTranscribe;
import org.jetbrains.annotations.Nullable;

@Schema(description="The transcribe operation element can be used to convert a PDF document into other document formats. Errors and inaccuracies can always occur during such conversions, so the endpoint allows a report to be generated to detect and evaluate possible transfer errors both in the event of an error and in the event of a success.")
@JsonPropertyOrder(value={"errorReport", "failureLevel", "html", "successReport"})
@JsonTypeName(value="Operation_ToolboxTranscribe_transcribe")
public class OperationToolboxTranscribeTranscribe {
    public static final String JSON_PROPERTY_ERROR_REPORT = "errorReport";
    private ErrorReportEnum errorReport = ErrorReportEnum.NONE;
    public static final String JSON_PROPERTY_FAILURE_LEVEL = "failureLevel";
    private FailureLevelEnum failureLevel = FailureLevelEnum.ERROR;
    public static final String JSON_PROPERTY_HTML = "html";
    private OperationHtmlTranscribe html;
    public static final String JSON_PROPERTY_SUCCESS_REPORT = "successReport";
    private SuccessReportEnum successReport = SuccessReportEnum.NONE;

    public OperationToolboxTranscribeTranscribe errorReport(ErrorReportEnum errorReport) {
        this.errorReport = errorReport;
        return this;
    }

    @Schema(name="This parameter determines if and in which form the XML report for a failed conversion is returned.  *   none = XML report is not returned *   message = XML report will be delivered as part of the error message *   file = XML report is saved to file")
    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ErrorReportEnum getErrorReport() {
        return this.errorReport;
    }

    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorReport(ErrorReportEnum errorReport) {
        this.errorReport = errorReport;
    }

    public OperationToolboxTranscribeTranscribe failureLevel(FailureLevelEnum failureLevel) {
        this.failureLevel = failureLevel;
        return this;
    }

    @Schema(name="This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure  *   warning = Documents for which warnings occur will also cause the conversion to fail. *   missingContent = Documents for which not all content could be converted correctly will also be considered as failures. *   error = Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.")
    @JsonProperty(value="failureLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FailureLevelEnum getFailureLevel() {
        return this.failureLevel;
    }

    @JsonProperty(value="failureLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureLevel(FailureLevelEnum failureLevel) {
        this.failureLevel = failureLevel;
    }

    public OperationToolboxTranscribeTranscribe html(OperationHtmlTranscribe html) {
        this.html = html;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="html")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationHtmlTranscribe getHtml() {
        return this.html;
    }

    @JsonProperty(value="html")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHtml(OperationHtmlTranscribe html) {
        this.html = html;
    }

    public OperationToolboxTranscribeTranscribe successReport(SuccessReportEnum successReport) {
        this.successReport = successReport;
        return this;
    }

    @Schema(name="This parameter determines if and in which form the XML report for a successful conversion is returned.  *   none = XML report is not returned *   linked = XML report is appended to the end of the target document. *   zip = target document and XML report are packed together in a ZIP archive.  **Important:** The format of the document created at \"errorReport\" and \"successReport\" is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.")
    @JsonProperty(value="successReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SuccessReportEnum getSuccessReport() {
        return this.successReport;
    }

    @JsonProperty(value="successReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccessReport(SuccessReportEnum successReport) {
        this.successReport = successReport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxTranscribeTranscribe operationToolboxTranscribeTranscribe = (OperationToolboxTranscribeTranscribe)o;
        return Objects.equals((Object)this.errorReport, (Object)operationToolboxTranscribeTranscribe.errorReport) && Objects.equals((Object)this.failureLevel, (Object)operationToolboxTranscribeTranscribe.failureLevel) && Objects.equals(this.html, operationToolboxTranscribeTranscribe.html) && Objects.equals((Object)this.successReport, (Object)operationToolboxTranscribeTranscribe.successReport);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorReport, this.failureLevel, this.html, this.successReport});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxTranscribeTranscribe {\n");
        sb.append("    errorReport: ").append(this.toIndentedString((Object)this.errorReport)).append("\n");
        sb.append("    failureLevel: ").append(this.toIndentedString((Object)this.failureLevel)).append("\n");
        sb.append("    html: ").append(this.toIndentedString(this.html)).append("\n");
        sb.append("    successReport: ").append(this.toIndentedString((Object)this.successReport)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SuccessReportEnum {
        NONE(String.valueOf("none")),
        ZIP(String.valueOf("zip")),
        LINKED(String.valueOf("linked"));

        private String value;

        private SuccessReportEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SuccessReportEnum fromValue(String value) {
            for (SuccessReportEnum b : SuccessReportEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FailureLevelEnum {
        WARNING(String.valueOf("warning")),
        MISSING_CONTENT(String.valueOf("missingContent")),
        ERROR(String.valueOf("error"));

        private String value;

        private FailureLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FailureLevelEnum fromValue(String value) {
            for (FailureLevelEnum b : FailureLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ErrorReportEnum {
        NONE(String.valueOf("none")),
        FILE(String.valueOf("file")),
        MESSAGE(String.valueOf("message"));

        private String value;

        private ErrorReportEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ErrorReportEnum fromValue(String value) {
            for (ErrorReportEnum b : ErrorReportEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

