/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The print operation element can be used to print documents.")
@JsonPropertyOrder(value={"autoRotate", "centerInPage", "copies", "dpi", "expandToMargins", "jobName", "mode", "pages", "printerName", "shrinkToMargins"})
@JsonTypeName(value="Operation_ToolboxPrint_print")
public class OperationToolboxPrintPrint {
    public static final String JSON_PROPERTY_AUTO_ROTATE = "autoRotate";
    private Boolean autoRotate = true;
    public static final String JSON_PROPERTY_CENTER_IN_PAGE = "centerInPage";
    private Boolean centerInPage = false;
    public static final String JSON_PROPERTY_COPIES = "copies";
    private Integer copies = 1;
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 0;
    public static final String JSON_PROPERTY_EXPAND_TO_MARGINS = "expandToMargins";
    private Boolean expandToMargins = false;
    public static final String JSON_PROPERTY_JOB_NAME = "jobName";
    private String jobName = "webPDF Print Job";
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.DEFAULT;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_PRINTER_NAME = "printerName";
    private String printerName = "";
    public static final String JSON_PROPERTY_SHRINK_TO_MARGINS = "shrinkToMargins";
    private Boolean shrinkToMargins = false;

    public OperationToolboxPrintPrint autoRotate(Boolean autoRotate) {
        this.autoRotate = autoRotate;
        return this;
    }

    @Schema(name="If \"true,\" the PDF document's orientation will be automatically adjusted in line with the printer's configured paper orientation.")
    @JsonProperty(value="autoRotate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAutoRotate() {
        return this.autoRotate;
    }

    @JsonProperty(value="autoRotate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoRotate(Boolean autoRotate) {
        this.autoRotate = autoRotate;
    }

    public OperationToolboxPrintPrint centerInPage(Boolean centerInPage) {
        this.centerInPage = centerInPage;
        return this;
    }

    @Schema(name="If \"true\", the PDF page will be centered in the middle of the paper.")
    @JsonProperty(value="centerInPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCenterInPage() {
        return this.centerInPage;
    }

    @JsonProperty(value="centerInPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCenterInPage(Boolean centerInPage) {
        this.centerInPage = centerInPage;
    }

    public OperationToolboxPrintPrint copies(Integer copies) {
        this.copies = copies;
        return this;
    }

    @Schema(name="Defines the number of copies that should be printed.")
    @JsonProperty(value="copies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getCopies() {
        return this.copies;
    }

    @JsonProperty(value="copies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCopies(Integer copies) {
        this.copies = copies;
    }

    public OperationToolboxPrintPrint dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="Sets the printer resolution for the \"image\" print mode. If this value is set to 0, the document will be printed, using a resolution suggested by the printer. (High resolutions will lead to better quality results, but will tremendously increase the required time and resources.)")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationToolboxPrintPrint expandToMargins(Boolean expandToMargins) {
        this.expandToMargins = expandToMargins;
        return this;
    }

    @Schema(name="If \"true,\" any PDF page that is smaller than the paper will be enlarged to fit the paper size.")
    @JsonProperty(value="expandToMargins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getExpandToMargins() {
        return this.expandToMargins;
    }

    @JsonProperty(value="expandToMargins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpandToMargins(Boolean expandToMargins) {
        this.expandToMargins = expandToMargins;
    }

    public OperationToolboxPrintPrint jobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    @Schema(name="This attribute is used to define the name of the print job (as shown in the Print Spooler in Windows, for example).")
    @JsonProperty(value="jobName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getJobName() {
        return this.jobName;
    }

    @JsonProperty(value="jobName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public OperationToolboxPrintPrint mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="Select the printing mode, that shall be used.  *   default = The drawing operations are applied to the printout as defined in the PDF document. *   image = Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result. *   raster = Every page of the document is rastered before printing. This is a compatibility mode for older printers.")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public OperationToolboxPrintPrint pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Defines which page(s) should be printed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationToolboxPrintPrint printerName(String printerName) {
        this.printerName = printerName;
        return this;
    }

    @Schema(name="This attribute is used to specify the name of the printer that should be used to print the PDF document. If a printer is not declared, then the system's default printer will be used for printing.")
    @JsonProperty(value="printerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPrinterName() {
        return this.printerName;
    }

    @JsonProperty(value="printerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public OperationToolboxPrintPrint shrinkToMargins(Boolean shrinkToMargins) {
        this.shrinkToMargins = shrinkToMargins;
        return this;
    }

    @Schema(name="If \"true,\" any PDF page that is larger than the paper will be shrunk to fit the paper size.")
    @JsonProperty(value="shrinkToMargins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShrinkToMargins() {
        return this.shrinkToMargins;
    }

    @JsonProperty(value="shrinkToMargins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShrinkToMargins(Boolean shrinkToMargins) {
        this.shrinkToMargins = shrinkToMargins;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxPrintPrint operationToolboxPrintPrint = (OperationToolboxPrintPrint)o;
        return Objects.equals(this.autoRotate, operationToolboxPrintPrint.autoRotate) && Objects.equals(this.centerInPage, operationToolboxPrintPrint.centerInPage) && Objects.equals(this.copies, operationToolboxPrintPrint.copies) && Objects.equals(this.dpi, operationToolboxPrintPrint.dpi) && Objects.equals(this.expandToMargins, operationToolboxPrintPrint.expandToMargins) && Objects.equals(this.jobName, operationToolboxPrintPrint.jobName) && Objects.equals((Object)this.mode, (Object)operationToolboxPrintPrint.mode) && Objects.equals(this.pages, operationToolboxPrintPrint.pages) && Objects.equals(this.printerName, operationToolboxPrintPrint.printerName) && Objects.equals(this.shrinkToMargins, operationToolboxPrintPrint.shrinkToMargins);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoRotate, this.centerInPage, this.copies, this.dpi, this.expandToMargins, this.jobName, this.mode, this.pages, this.printerName, this.shrinkToMargins});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxPrintPrint {\n");
        sb.append("    autoRotate: ").append(this.toIndentedString(this.autoRotate)).append("\n");
        sb.append("    centerInPage: ").append(this.toIndentedString(this.centerInPage)).append("\n");
        sb.append("    copies: ").append(this.toIndentedString(this.copies)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    expandToMargins: ").append(this.toIndentedString(this.expandToMargins)).append("\n");
        sb.append("    jobName: ").append(this.toIndentedString(this.jobName)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    printerName: ").append(this.toIndentedString(this.printerName)).append("\n");
        sb.append("    shrinkToMargins: ").append(this.toIndentedString(this.shrinkToMargins)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        DEFAULT(String.valueOf("default")),
        RASTER(String.valueOf("raster")),
        IMAGE(String.valueOf("image"));

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

