/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The move operation element can be used to change the order of the document's pages.")
@JsonPropertyOrder(value={"mode", "order", "pages", "targetPosition"})
@JsonTypeName(value="Operation_ToolboxMove_move")
public class OperationToolboxMoveMove {
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.AFTER_PAGE;
    public static final String JSON_PROPERTY_ORDER = "order";
    private OrderEnum order = OrderEnum.PRESERVE;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "1";
    public static final String JSON_PROPERTY_TARGET_POSITION = "targetPosition";
    private Integer targetPosition = 1;

    public OperationToolboxMoveMove mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="Used to specify whether the selected page range should be inserted before or after the selected position in the document.  *   afterPage = After the selected position. *   beforePage = Before the selected position.")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public OperationToolboxMoveMove order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @Schema(name="Used to select the order of the selected pages at the new position.  *   preserve = Keeps the original order in which the pages were found in the document. *   reverse = Reverses the original order in which the pages were found in the document.")
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OrderEnum getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public OperationToolboxMoveMove pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Used to define which page(s) should be moved. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\").")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationToolboxMoveMove targetPosition(Integer targetPosition) {
        this.targetPosition = targetPosition;
        return this;
    }

    @Schema(name="Used to select the page number after or before which the selected page range should be inserted. This page must not be part of the page range being moved.")
    @JsonProperty(value="targetPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getTargetPosition() {
        return this.targetPosition;
    }

    @JsonProperty(value="targetPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetPosition(Integer targetPosition) {
        this.targetPosition = targetPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxMoveMove operationToolboxMoveMove = (OperationToolboxMoveMove)o;
        return Objects.equals((Object)this.mode, (Object)operationToolboxMoveMove.mode) && Objects.equals((Object)this.order, (Object)operationToolboxMoveMove.order) && Objects.equals(this.pages, operationToolboxMoveMove.pages) && Objects.equals(this.targetPosition, operationToolboxMoveMove.targetPosition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.order, this.pages, this.targetPosition});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxMoveMove {\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    targetPosition: ").append(this.toIndentedString(this.targetPosition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        PRESERVE(String.valueOf("preserve")),
        REVERSE(String.valueOf("reverse"));

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrderEnum fromValue(String value) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ModeEnum {
        BEFORE_PAGE(String.valueOf("beforePage")),
        AFTER_PAGE(String.valueOf("afterPage"));

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

