/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a target TIFF image format.")
@JsonPropertyOrder(value={"blackAndWhiteQuality", "compression", "dpi", "height", "jpegQuality", "metrics", "multipage", "width"})
@JsonTypeName(value="Operation_Tiff")
public class OperationTiff {
    public static final String JSON_PROPERTY_BLACK_AND_WHITE_QUALITY = "blackAndWhiteQuality";
    private BlackAndWhiteQualityEnum blackAndWhiteQuality = BlackAndWhiteQualityEnum.HIGH;
    public static final String JSON_PROPERTY_COMPRESSION = "compression";
    private CompressionEnum compression = CompressionEnum.NONE;
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 72;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 0;
    public static final String JSON_PROPERTY_JPEG_QUALITY = "jpegQuality";
    private Integer jpegQuality = 80;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_MULTIPAGE = "multipage";
    private Boolean multipage = false;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 0;

    public OperationTiff blackAndWhiteQuality(BlackAndWhiteQualityEnum blackAndWhiteQuality) {
        this.blackAndWhiteQuality = blackAndWhiteQuality;
        return this;
    }

    @Schema(name="For \"tif\" exports, this parameter is used to define the quality of black-and-white images if \"group3\" or \"group4\" is used as a compression method. The higher the quality, the more time that will be required in order to render the image:  *   low = Direct conversion (best reserved for \"text only\" content) *   middle = A diffusion filter will be applied to the image before conversion *   high = Greyscale conversion and a diffusion filter will be applied to the image before conversion")
    @JsonProperty(value="blackAndWhiteQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public BlackAndWhiteQualityEnum getBlackAndWhiteQuality() {
        return this.blackAndWhiteQuality;
    }

    @JsonProperty(value="blackAndWhiteQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBlackAndWhiteQuality(BlackAndWhiteQualityEnum blackAndWhiteQuality) {
        this.blackAndWhiteQuality = blackAndWhiteQuality;
    }

    public OperationTiff compression(CompressionEnum compression) {
        this.compression = compression;
        return this;
    }

    @Schema(name="This parameter is used to specify the compression method when exporting pages as \"tif\" images. The following values are available:  *   none = No compression *   rle = TIFF CCITT Modified Huffman RLE compression *   deflate = TIFF Deflate lossless compression (Zip-in-TIFF). *   group3 = TIFF CCITT Group 3 fax encoding *   group4 = TIFF CCITT Group 4 fax encoding *   jpeg = TIFF JPEG-in-TIFF compression *   lzw = TIFF LZW compression *   packbits = TIFF Byte-oriented run-length encoding \"PackBits\" compression *   zlib = TIFF ZLib compression")
    @JsonProperty(value="compression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CompressionEnum getCompression() {
        return this.compression;
    }

    @JsonProperty(value="compression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompression(CompressionEnum compression) {
        this.compression = compression;
    }

    public OperationTiff dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="This parameter is used to define the image's DPI resolution. The larger the value, the larger the image's x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationTiff height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(name="Used to limit the maximum height of the exported image. 0 = No restriction")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public OperationTiff jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @Schema(name="When exporting to \"jpg\" format, this parameter can be used to define the image's quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.")
    @JsonProperty(value="jpegQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    @JsonProperty(value="jpegQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public OperationTiff metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationTiff multipage(Boolean multipage) {
        this.multipage = multipage;
        return this;
    }

    @Schema(name="If \"true,\" a \"multi-page TIFF\" will be created when multiple pages are exported as \"tif\" images. All the pages will be exported to a single file, and a ZIP file with individual images will not be generated.")
    @JsonProperty(value="multipage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getMultipage() {
        return this.multipage;
    }

    @JsonProperty(value="multipage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultipage(Boolean multipage) {
        this.multipage = multipage;
    }

    public OperationTiff width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(name="Used to limit the maximum width of the exported image. 0 = No restriction")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTiff operationTiff = (OperationTiff)o;
        return Objects.equals((Object)this.blackAndWhiteQuality, (Object)operationTiff.blackAndWhiteQuality) && Objects.equals((Object)this.compression, (Object)operationTiff.compression) && Objects.equals(this.dpi, operationTiff.dpi) && Objects.equals(this.height, operationTiff.height) && Objects.equals(this.jpegQuality, operationTiff.jpegQuality) && Objects.equals((Object)this.metrics, (Object)operationTiff.metrics) && Objects.equals(this.multipage, operationTiff.multipage) && Objects.equals(this.width, operationTiff.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blackAndWhiteQuality, this.compression, this.dpi, this.height, this.jpegQuality, this.metrics, this.multipage, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTiff {\n");
        sb.append("    blackAndWhiteQuality: ").append(this.toIndentedString((Object)this.blackAndWhiteQuality)).append("\n");
        sb.append("    compression: ").append(this.toIndentedString((Object)this.compression)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    multipage: ").append(this.toIndentedString(this.multipage)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        PT(String.valueOf("pt")),
        PC(String.valueOf("pc")),
        PX(String.valueOf("px")),
        MM(String.valueOf("mm")),
        IN(String.valueOf("in"));

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CompressionEnum {
        NONE(String.valueOf("none")),
        RLE(String.valueOf("rle")),
        DEFLATE(String.valueOf("deflate")),
        GROUP3(String.valueOf("group3")),
        GROUP4(String.valueOf("group4")),
        JPEG(String.valueOf("jpeg")),
        LZW(String.valueOf("lzw")),
        PACKBITS(String.valueOf("packbits")),
        ZLIB(String.valueOf("zlib"));

        private String value;

        private CompressionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompressionEnum fromValue(String value) {
            for (CompressionEnum b : CompressionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BlackAndWhiteQualityEnum {
        LOW(String.valueOf("low")),
        MIDDLE(String.valueOf("middle")),
        HIGH(String.valueOf("high"));

        private String value;

        private BlackAndWhiteQualityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BlackAndWhiteQualityEnum fromValue(String value) {
            for (BlackAndWhiteQualityEnum b : BlackAndWhiteQualityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

