/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationAppearanceSource;
import net.webpdf.wsclient.openapi.OperationRectangle;
import org.jetbrains.annotations.Nullable;

@Schema(description="An annotation that adds a note icon to a page.")
@JsonPropertyOrder(value={"appearanceGeneration", "color", "contents", "creator", "customIconName", "hidden", "icon", "initialOpen", "intents", "invisible", "locked", "name", "normalAppearance", "opacity", "page", "position", "printable", "rotatable", "subject", "viewable", "writable", "zoomable"})
@JsonTypeName(value="Operation_TextAnnotation")
public class OperationTextAnnotation {
    public static final String JSON_PROPERTY_APPEARANCE_GENERATION = "appearanceGeneration";
    private AppearanceGenerationEnum appearanceGeneration = AppearanceGenerationEnum.NON_STANDARD;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#4800FF";
    public static final String JSON_PROPERTY_CONTENTS = "contents";
    private String contents = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_CUSTOM_ICON_NAME = "customIconName";
    private String customIconName = "";
    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden = false;
    public static final String JSON_PROPERTY_ICON = "icon";
    private IconEnum icon = IconEnum.NOTE;
    public static final String JSON_PROPERTY_INITIAL_OPEN = "initialOpen";
    private Boolean initialOpen = true;
    public static final String JSON_PROPERTY_INTENTS = "intents";
    private String intents = "";
    public static final String JSON_PROPERTY_INVISIBLE = "invisible";
    private Boolean invisible = false;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_NORMAL_APPEARANCE = "normalAppearance";
    private OperationAppearanceSource normalAppearance;
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationRectangle position;
    public static final String JSON_PROPERTY_PRINTABLE = "printable";
    private Boolean printable = false;
    public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
    private Boolean rotatable = true;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";
    public static final String JSON_PROPERTY_VIEWABLE = "viewable";
    private Boolean viewable = true;
    public static final String JSON_PROPERTY_WRITABLE = "writable";
    private Boolean writable = true;
    public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
    private Boolean zoomable = true;

    public OperationTextAnnotation appearanceGeneration(AppearanceGenerationEnum appearanceGeneration) {
        this.appearanceGeneration = appearanceGeneration;
        return this;
    }

    @Schema(name="Determines for which named annotations appearance streams shall be generated.  **Important:** Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those.  *   always = An appearance stream shall be prepared for all created named annotations. *   never = Don't provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations. *   nonStandard = Only provide appearance streams for non-standard annotations.")
    @JsonProperty(value="appearanceGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AppearanceGenerationEnum getAppearanceGeneration() {
        return this.appearanceGeneration;
    }

    @JsonProperty(value="appearanceGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppearanceGeneration(AppearanceGenerationEnum appearanceGeneration) {
        this.appearanceGeneration = appearanceGeneration;
    }

    public OperationTextAnnotation color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationTextAnnotation contents(String contents) {
        this.contents = contents;
        return this;
    }

    @Schema(name="This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).")
    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContents(String contents) {
        this.contents = contents;
    }

    public OperationTextAnnotation creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationTextAnnotation customIconName(String customIconName) {
        this.customIconName = customIconName;
        return this;
    }

    @Schema(name="Sets a custom icon name for this annotation.  **Important:** This name shall always take precedence over possibly set standard names. (icon)")
    @JsonProperty(value="customIconName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCustomIconName() {
        return this.customIconName;
    }

    @JsonProperty(value="customIconName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomIconName(String customIconName) {
        this.customIconName = customIconName;
    }

    public OperationTextAnnotation hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public OperationTextAnnotation icon(IconEnum icon) {
        this.icon = icon;
        return this;
    }

    @Schema(name="Used to specify the icon that should be displayed for the note on the page. The following values are available:  *   check = The text annotation approves the content. *   checkmark = The text annotation adds a gray checkmark to the content. *   circle = The text annotation is a comment on the circled content. *   comment = The text annotation is a comment to the marked contents. *   cross = The text annotation marks the content or crosses it out. *   crossHair = The text annotation targets the content in the crosshair. *   insert = The text annotation is suggesting inserting some content. *   key = The text annotation marks or contains a key content/information. *   note = The text annotation is a mere note concerning the marked content. *   help = The text annotation provides helpful information concerning the marked content. *   newParagraph = The text annotation suggests adding a new Paragraph at a specific point. *   paragraph = The text annotation is concerning the whole paragraph. *   rightArrow = The text annotation is concerning the content to the right. *   rightPointer = The text annotation is concerning the content to the right. *   star = The text annotation marks content as especially important. *   upArrow = The text annotation is concerning the content at the top. *   upLeftArrow = The text annotation is concerning the content at the top left. *   unnamed = The text annotation shall not provide a predefined name.")
    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public IconEnum getIcon() {
        return this.icon;
    }

    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIcon(IconEnum icon) {
        this.icon = icon;
    }

    public OperationTextAnnotation initialOpen(Boolean initialOpen) {
        this.initialOpen = initialOpen;
        return this;
    }

    @Schema(name="If this value is set to \"true,\" the popup for the corresponding \"note\" annotation will be opened as soon as the corresponding document page is viewed.")
    @JsonProperty(value="initialOpen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getInitialOpen() {
        return this.initialOpen;
    }

    @JsonProperty(value="initialOpen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialOpen(Boolean initialOpen) {
        this.initialOpen = initialOpen;
    }

    public OperationTextAnnotation intents(String intents) {
        this.intents = intents;
        return this;
    }

    @Schema(name="Used to set the intention of the annotation.  **Important:** The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.")
    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIntents() {
        return this.intents;
    }

    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntents(String intents) {
        this.intents = intents;
    }

    public OperationTextAnnotation invisible(Boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getInvisible() {
        return this.invisible;
    }

    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvisible(Boolean invisible) {
        this.invisible = invisible;
    }

    public OperationTextAnnotation locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be locked so that no changes can be made to it.")
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public OperationTextAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationTextAnnotation normalAppearance(OperationAppearanceSource normalAppearance) {
        this.normalAppearance = normalAppearance;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="normalAppearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationAppearanceSource getNormalAppearance() {
        return this.normalAppearance;
    }

    @JsonProperty(value="normalAppearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNormalAppearance(OperationAppearanceSource normalAppearance) {
        this.normalAppearance = normalAppearance;
    }

    public OperationTextAnnotation opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="This percentage value is used to set the annotation's transparency.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationTextAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Set the number of the page, the annotation shall be placed on.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationTextAnnotation position(OperationRectangle position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationRectangle getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationRectangle position) {
        this.position = position;
    }

    public OperationTextAnnotation printable(Boolean printable) {
        this.printable = printable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be included when the page is printed out.")
    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPrintable() {
        return this.printable;
    }

    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintable(Boolean printable) {
        this.printable = printable;
    }

    public OperationTextAnnotation rotatable(Boolean rotatable) {
        this.rotatable = rotatable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRotatable() {
        return this.rotatable;
    }

    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotatable(Boolean rotatable) {
        this.rotatable = rotatable;
    }

    public OperationTextAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public OperationTextAnnotation viewable(Boolean viewable) {
        this.viewable = viewable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be shown on the document's page.")
    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getViewable() {
        return this.viewable;
    }

    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewable(Boolean viewable) {
        this.viewable = viewable;
    }

    public OperationTextAnnotation writable(Boolean writable) {
        this.writable = writable;
        return this;
    }

    @Schema(name="If this value is set to true, it will be possible to change the annotation's contents later on.")
    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getWritable() {
        return this.writable;
    }

    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWritable(Boolean writable) {
        this.writable = writable;
    }

    public OperationTextAnnotation zoomable(Boolean zoomable) {
        this.zoomable = zoomable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getZoomable() {
        return this.zoomable;
    }

    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTextAnnotation operationTextAnnotation = (OperationTextAnnotation)o;
        return Objects.equals((Object)this.appearanceGeneration, (Object)operationTextAnnotation.appearanceGeneration) && Objects.equals(this.color, operationTextAnnotation.color) && Objects.equals(this.contents, operationTextAnnotation.contents) && Objects.equals(this.creator, operationTextAnnotation.creator) && Objects.equals(this.customIconName, operationTextAnnotation.customIconName) && Objects.equals(this.hidden, operationTextAnnotation.hidden) && Objects.equals((Object)this.icon, (Object)operationTextAnnotation.icon) && Objects.equals(this.initialOpen, operationTextAnnotation.initialOpen) && Objects.equals(this.intents, operationTextAnnotation.intents) && Objects.equals(this.invisible, operationTextAnnotation.invisible) && Objects.equals(this.locked, operationTextAnnotation.locked) && Objects.equals(this.name, operationTextAnnotation.name) && Objects.equals(this.normalAppearance, operationTextAnnotation.normalAppearance) && Objects.equals(this.opacity, operationTextAnnotation.opacity) && Objects.equals(this.page, operationTextAnnotation.page) && Objects.equals(this.position, operationTextAnnotation.position) && Objects.equals(this.printable, operationTextAnnotation.printable) && Objects.equals(this.rotatable, operationTextAnnotation.rotatable) && Objects.equals(this.subject, operationTextAnnotation.subject) && Objects.equals(this.viewable, operationTextAnnotation.viewable) && Objects.equals(this.writable, operationTextAnnotation.writable) && Objects.equals(this.zoomable, operationTextAnnotation.zoomable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appearanceGeneration, this.color, this.contents, this.creator, this.customIconName, this.hidden, this.icon, this.initialOpen, this.intents, this.invisible, this.locked, this.name, this.normalAppearance, this.opacity, this.page, this.position, this.printable, this.rotatable, this.subject, this.viewable, this.writable, this.zoomable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTextAnnotation {\n");
        sb.append("    appearanceGeneration: ").append(this.toIndentedString((Object)this.appearanceGeneration)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    customIconName: ").append(this.toIndentedString(this.customIconName)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString((Object)this.icon)).append("\n");
        sb.append("    initialOpen: ").append(this.toIndentedString(this.initialOpen)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    invisible: ").append(this.toIndentedString(this.invisible)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    normalAppearance: ").append(this.toIndentedString(this.normalAppearance)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    printable: ").append(this.toIndentedString(this.printable)).append("\n");
        sb.append("    rotatable: ").append(this.toIndentedString(this.rotatable)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    viewable: ").append(this.toIndentedString(this.viewable)).append("\n");
        sb.append("    writable: ").append(this.toIndentedString(this.writable)).append("\n");
        sb.append("    zoomable: ").append(this.toIndentedString(this.zoomable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IconEnum {
        CHECK(String.valueOf("check")),
        CHECKMARK(String.valueOf("checkmark")),
        CIRCLE(String.valueOf("circle")),
        COMMENT(String.valueOf("comment")),
        CROSS(String.valueOf("cross")),
        CROSS_HAIR(String.valueOf("crossHair")),
        INSERT(String.valueOf("insert")),
        KEY(String.valueOf("key")),
        NOTE(String.valueOf("note")),
        HELP(String.valueOf("help")),
        NEW_PARAGRAPH(String.valueOf("newParagraph")),
        PARAGRAPH(String.valueOf("paragraph")),
        RIGHT_ARROW(String.valueOf("rightArrow")),
        RIGHT_POINTER(String.valueOf("rightPointer")),
        STAR(String.valueOf("star")),
        UP_ARROW(String.valueOf("upArrow")),
        UP_LEFT_ARROW(String.valueOf("upLeftArrow")),
        UNNAMED(String.valueOf("unnamed"));

        private String value;

        private IconEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IconEnum fromValue(String value) {
            for (IconEnum b : IconEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AppearanceGenerationEnum {
        ALWAYS(String.valueOf("Always")),
        NEVER(String.valueOf("Never")),
        NON_STANDARD(String.valueOf("nonStandard"));

        private String value;

        private AppearanceGenerationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AppearanceGenerationEnum fromValue(String value) {
            for (AppearanceGenerationEnum b : AppearanceGenerationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

