/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains the Base64-encoded JSON structure that is used as variables in the HTML template if \"useAsTemplate\" has a value of \"true\".  Example for data as JSON structure:  ```json                     {     \"page1\": \"Text for page 1\",     \"page2\": \"Text for page 2\",     \"page3\": \"Text for page 3\",     \"image\": {     \"name\": \"Warning!\",     \"data\": \"... BASE64 encoded image ...\"     } } ```  Within the HTML document, the \"custom.\" prefix will be prepended to each variable from the JSON structure. The variables can then be used as follows in the HTML code:  ```html                     <body>     <div class=\"page\">         <h1>This is Page 1</h1>         <i>${custom.page1}</i>         <br/>         ${custom.image.name}         <img src=\"${custom.image.data}\" width=\"100\" height=\"100\"/>     </div>     <div class=\"page\">         <h1>This is Page 2</h1>         <b>${custom.page2}</b>     </div>     <div class=\"page\">         <h1>This is Page 3</h1>         <u>${custom.page3}</u>     </div> </body> ```  For more information regarding the use of the templates, please refer to the chapter \"Server Conversion - Templates\" document.")
@JsonPropertyOrder(value={"source", "uri", "value"})
@JsonTypeName(value="Operation_TemplateData")
public class OperationTemplateData {
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.VALUE;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private byte[] value;

    public OperationTemplateData source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Schema(name="Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public OperationTemplateData uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(name="The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public OperationTemplateData value(byte[] value) {
        this.value = value;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTemplateData operationTemplateData = (OperationTemplateData)o;
        return Objects.equals((Object)this.source, (Object)operationTemplateData.source) && Objects.equals(this.uri, operationTemplateData.uri) && Arrays.equals(this.value, operationTemplateData.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.uri, Arrays.hashCode(this.value)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTemplateData {\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        VALUE(String.valueOf("value")),
        URI(String.valueOf("uri"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

