/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Selects parameters for the creation of SVGs, possibly contained in resulting documents.")
@JsonPropertyOrder(value={"decimalPrecision", "graphicsStateMode", "pathDrawMode"})
@JsonTypeName(value="Operation_SvgFormat")
public class OperationSvgFormat {
    public static final String JSON_PROPERTY_DECIMAL_PRECISION = "decimalPrecision";
    private Integer decimalPrecision = 2;
    public static final String JSON_PROPERTY_GRAPHICS_STATE_MODE = "graphicsStateMode";
    private GraphicsStateModeEnum graphicsStateMode = GraphicsStateModeEnum.CENTRALIZE;
    public static final String JSON_PROPERTY_PATH_DRAW_MODE = "pathDrawMode";
    private PathDrawModeEnum pathDrawMode = PathDrawModeEnum.COMPACT;

    public OperationSvgFormat decimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
        return this;
    }

    @Schema(name="Selects the number of decimal places for numeric values of contained SVGs.  **Important:** The number of decimal places directly influences the size of the resulting file. (should SVGs be contained.) However: Higher values will result in a better SVG quality.")
    @JsonProperty(value="decimalPrecision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDecimalPrecision() {
        return this.decimalPrecision;
    }

    @JsonProperty(value="decimalPrecision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public OperationSvgFormat graphicsStateMode(GraphicsStateModeEnum graphicsStateMode) {
        this.graphicsStateMode = graphicsStateMode;
        return this;
    }

    @Schema(name="Selects the SVG syntax used for formatting graphics states.  *   verbose = Writes verbose graphics states and groups and always prefers direct path definitions. *   centralize = Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the \"use\" syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)")
    @JsonProperty(value="graphicsStateMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public GraphicsStateModeEnum getGraphicsStateMode() {
        return this.graphicsStateMode;
    }

    @JsonProperty(value="graphicsStateMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGraphicsStateMode(GraphicsStateModeEnum graphicsStateMode) {
        this.graphicsStateMode = graphicsStateMode;
    }

    public OperationSvgFormat pathDrawMode(PathDrawModeEnum pathDrawMode) {
        this.pathDrawMode = pathDrawMode;
        return this;
    }

    @Schema(name="Selects the SVG syntax used for formatting paths.  *   verbose = Writes verbose paths, containing a human readable complete and simple syntax. *   compress = Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).")
    @JsonProperty(value="pathDrawMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PathDrawModeEnum getPathDrawMode() {
        return this.pathDrawMode;
    }

    @JsonProperty(value="pathDrawMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPathDrawMode(PathDrawModeEnum pathDrawMode) {
        this.pathDrawMode = pathDrawMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSvgFormat operationSvgFormat = (OperationSvgFormat)o;
        return Objects.equals(this.decimalPrecision, operationSvgFormat.decimalPrecision) && Objects.equals((Object)this.graphicsStateMode, (Object)operationSvgFormat.graphicsStateMode) && Objects.equals((Object)this.pathDrawMode, (Object)operationSvgFormat.pathDrawMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.decimalPrecision, this.graphicsStateMode, this.pathDrawMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSvgFormat {\n");
        sb.append("    decimalPrecision: ").append(this.toIndentedString(this.decimalPrecision)).append("\n");
        sb.append("    graphicsStateMode: ").append(this.toIndentedString((Object)this.graphicsStateMode)).append("\n");
        sb.append("    pathDrawMode: ").append(this.toIndentedString((Object)this.pathDrawMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PathDrawModeEnum {
        VERBOSE(String.valueOf("verbose")),
        COMPACT(String.valueOf("compact"));

        private String value;

        private PathDrawModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PathDrawModeEnum fromValue(String value) {
            for (PathDrawModeEnum b : PathDrawModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum GraphicsStateModeEnum {
        VERBOSE(String.valueOf("verbose")),
        CENTRALIZE(String.valueOf("centralize"));

        private String value;

        private GraphicsStateModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GraphicsStateModeEnum fromValue(String value) {
            for (GraphicsStateModeEnum b : GraphicsStateModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

