/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a target SVG image format.")
@JsonPropertyOrder(value={"decimalPrecision", "dpi", "graphicsStateMode", "height", "metrics", "pathDrawMode", "width"})
@JsonTypeName(value="Operation_Svg")
public class OperationSvg {
    public static final String JSON_PROPERTY_DECIMAL_PRECISION = "decimalPrecision";
    private Integer decimalPrecision = 2;
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 72;
    public static final String JSON_PROPERTY_GRAPHICS_STATE_MODE = "graphicsStateMode";
    private GraphicsStateModeEnum graphicsStateMode = GraphicsStateModeEnum.CENTRALIZE;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 0;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_PATH_DRAW_MODE = "pathDrawMode";
    private PathDrawModeEnum pathDrawMode = PathDrawModeEnum.COMPACT;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 0;

    public OperationSvg decimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
        return this;
    }

    @Schema(name="Selects the number of decimal places for numeric values of the resulting SVG.  **Important:** The number of decimal places directly influences the size of the resulting file. However: Higher values will result in a better SVG quality.")
    @JsonProperty(value="decimalPrecision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDecimalPrecision() {
        return this.decimalPrecision;
    }

    @JsonProperty(value="decimalPrecision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public OperationSvg dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="This parameter is used to define the image's DPI resolution. The larger the value, the larger the image's x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationSvg graphicsStateMode(GraphicsStateModeEnum graphicsStateMode) {
        this.graphicsStateMode = graphicsStateMode;
        return this;
    }

    @Schema(name="Selects the SVG syntax used for formatting graphics states.  *   verbose = Writes verbose graphics states and groups and always prefers direct path definitions. *   centralize = Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the \"use\" syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)")
    @JsonProperty(value="graphicsStateMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public GraphicsStateModeEnum getGraphicsStateMode() {
        return this.graphicsStateMode;
    }

    @JsonProperty(value="graphicsStateMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGraphicsStateMode(GraphicsStateModeEnum graphicsStateMode) {
        this.graphicsStateMode = graphicsStateMode;
    }

    public OperationSvg height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(name="Used to limit the maximum height of the exported image. 0 = No restriction")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public OperationSvg metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationSvg pathDrawMode(PathDrawModeEnum pathDrawMode) {
        this.pathDrawMode = pathDrawMode;
        return this;
    }

    @Schema(name="Selects the SVG syntax used for formatting paths.  *   verbose = Writes verbose paths, containing a human readable complete and simple syntax. *   compress = Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).")
    @JsonProperty(value="pathDrawMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PathDrawModeEnum getPathDrawMode() {
        return this.pathDrawMode;
    }

    @JsonProperty(value="pathDrawMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPathDrawMode(PathDrawModeEnum pathDrawMode) {
        this.pathDrawMode = pathDrawMode;
    }

    public OperationSvg width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(name="Used to limit the maximum width of the exported image. 0 = No restriction")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSvg operationSvg = (OperationSvg)o;
        return Objects.equals(this.decimalPrecision, operationSvg.decimalPrecision) && Objects.equals(this.dpi, operationSvg.dpi) && Objects.equals((Object)this.graphicsStateMode, (Object)operationSvg.graphicsStateMode) && Objects.equals(this.height, operationSvg.height) && Objects.equals((Object)this.metrics, (Object)operationSvg.metrics) && Objects.equals((Object)this.pathDrawMode, (Object)operationSvg.pathDrawMode) && Objects.equals(this.width, operationSvg.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.decimalPrecision, this.dpi, this.graphicsStateMode, this.height, this.metrics, this.pathDrawMode, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSvg {\n");
        sb.append("    decimalPrecision: ").append(this.toIndentedString(this.decimalPrecision)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    graphicsStateMode: ").append(this.toIndentedString((Object)this.graphicsStateMode)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    pathDrawMode: ").append(this.toIndentedString((Object)this.pathDrawMode)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PathDrawModeEnum {
        VERBOSE(String.valueOf("verbose")),
        COMPACT(String.valueOf("compact"));

        private String value;

        private PathDrawModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PathDrawModeEnum fromValue(String value) {
            for (PathDrawModeEnum b : PathDrawModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MetricsEnum {
        PT(String.valueOf("pt")),
        PC(String.valueOf("pc")),
        PX(String.valueOf("px")),
        MM(String.valueOf("mm")),
        IN(String.valueOf("in"));

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum GraphicsStateModeEnum {
        VERBOSE(String.valueOf("verbose")),
        CENTRALIZE(String.valueOf("centralize"));

        private String value;

        private GraphicsStateModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GraphicsStateModeEnum fromValue(String value) {
            for (GraphicsStateModeEnum b : GraphicsStateModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

