/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationBorder;
import net.webpdf.wsclient.openapi.OperationPositionSimpleShapeAnnotation;
import org.jetbrains.annotations.Nullable;

@Schema(description="An annotation that draws a rectangle on a page.")
@JsonPropertyOrder(value={"border", "color", "contents", "creator", "drawMode", "hidden", "intents", "interiorColor", "invisible", "locked", "name", "opacity", "page", "position", "printable", "rotatable", "subject", "viewable", "writable", "zoomable"})
@JsonTypeName(value="Operation_SquareAnnotation")
public class OperationSquareAnnotation {
    public static final String JSON_PROPERTY_BORDER = "border";
    private OperationBorder border;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#4800FF";
    public static final String JSON_PROPERTY_CONTENTS = "contents";
    private String contents = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_DRAW_MODE = "drawMode";
    private DrawModeEnum drawMode = DrawModeEnum.FILL_AND_STROKE;
    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden = false;
    public static final String JSON_PROPERTY_INTENTS = "intents";
    private String intents = "";
    public static final String JSON_PROPERTY_INTERIOR_COLOR = "interiorColor";
    private String interiorColor = "#000000";
    public static final String JSON_PROPERTY_INVISIBLE = "invisible";
    private Boolean invisible = false;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationPositionSimpleShapeAnnotation position;
    public static final String JSON_PROPERTY_PRINTABLE = "printable";
    private Boolean printable = false;
    public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
    private Boolean rotatable = true;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";
    public static final String JSON_PROPERTY_VIEWABLE = "viewable";
    private Boolean viewable = true;
    public static final String JSON_PROPERTY_WRITABLE = "writable";
    private Boolean writable = true;
    public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
    private Boolean zoomable = true;

    public OperationSquareAnnotation border(OperationBorder border) {
        this.border = border;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationBorder getBorder() {
        return this.border;
    }

    @JsonProperty(value="border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBorder(OperationBorder border) {
        this.border = border;
    }

    public OperationSquareAnnotation color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationSquareAnnotation contents(String contents) {
        this.contents = contents;
        return this;
    }

    @Schema(name="This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).")
    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContents(String contents) {
        this.contents = contents;
    }

    public OperationSquareAnnotation creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationSquareAnnotation drawMode(DrawModeEnum drawMode) {
        this.drawMode = drawMode;
        return this;
    }

    @Schema(name="Sets the draw mode for a geometrical shape.  *   fill = The shape shall be filled with a given interior color. *   stroke = The outline of the shape shall be stroked with a given color. *   fillAndStroke = The shall shall be filled with a given interior color and it's outline shall be stroked with a given color.")
    @JsonProperty(value="drawMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DrawModeEnum getDrawMode() {
        return this.drawMode;
    }

    @JsonProperty(value="drawMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDrawMode(DrawModeEnum drawMode) {
        this.drawMode = drawMode;
    }

    public OperationSquareAnnotation hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public OperationSquareAnnotation intents(String intents) {
        this.intents = intents;
        return this;
    }

    @Schema(name="Used to set the intention of the annotation.  **Important:** The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.")
    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIntents() {
        return this.intents;
    }

    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntents(String intents) {
        this.intents = intents;
    }

    public OperationSquareAnnotation interiorColor(String interiorColor) {
        this.interiorColor = interiorColor;
        return this;
    }

    @Schema(name="Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="interiorColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInteriorColor() {
        return this.interiorColor;
    }

    @JsonProperty(value="interiorColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInteriorColor(String interiorColor) {
        this.interiorColor = interiorColor;
    }

    public OperationSquareAnnotation invisible(Boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getInvisible() {
        return this.invisible;
    }

    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvisible(Boolean invisible) {
        this.invisible = invisible;
    }

    public OperationSquareAnnotation locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be locked so that no changes can be made to it.")
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public OperationSquareAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationSquareAnnotation opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="This percentage value is used to set the annotation's transparency.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationSquareAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Set the number of the page, the annotation shall be placed on.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationSquareAnnotation position(OperationPositionSimpleShapeAnnotation position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPositionSimpleShapeAnnotation getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationPositionSimpleShapeAnnotation position) {
        this.position = position;
    }

    public OperationSquareAnnotation printable(Boolean printable) {
        this.printable = printable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be included when the page is printed out.")
    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPrintable() {
        return this.printable;
    }

    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintable(Boolean printable) {
        this.printable = printable;
    }

    public OperationSquareAnnotation rotatable(Boolean rotatable) {
        this.rotatable = rotatable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRotatable() {
        return this.rotatable;
    }

    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotatable(Boolean rotatable) {
        this.rotatable = rotatable;
    }

    public OperationSquareAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public OperationSquareAnnotation viewable(Boolean viewable) {
        this.viewable = viewable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be shown on the document's page.")
    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getViewable() {
        return this.viewable;
    }

    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewable(Boolean viewable) {
        this.viewable = viewable;
    }

    public OperationSquareAnnotation writable(Boolean writable) {
        this.writable = writable;
        return this;
    }

    @Schema(name="If this value is set to true, it will be possible to change the annotation's contents later on.")
    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getWritable() {
        return this.writable;
    }

    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWritable(Boolean writable) {
        this.writable = writable;
    }

    public OperationSquareAnnotation zoomable(Boolean zoomable) {
        this.zoomable = zoomable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getZoomable() {
        return this.zoomable;
    }

    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSquareAnnotation operationSquareAnnotation = (OperationSquareAnnotation)o;
        return Objects.equals(this.border, operationSquareAnnotation.border) && Objects.equals(this.color, operationSquareAnnotation.color) && Objects.equals(this.contents, operationSquareAnnotation.contents) && Objects.equals(this.creator, operationSquareAnnotation.creator) && Objects.equals((Object)this.drawMode, (Object)operationSquareAnnotation.drawMode) && Objects.equals(this.hidden, operationSquareAnnotation.hidden) && Objects.equals(this.intents, operationSquareAnnotation.intents) && Objects.equals(this.interiorColor, operationSquareAnnotation.interiorColor) && Objects.equals(this.invisible, operationSquareAnnotation.invisible) && Objects.equals(this.locked, operationSquareAnnotation.locked) && Objects.equals(this.name, operationSquareAnnotation.name) && Objects.equals(this.opacity, operationSquareAnnotation.opacity) && Objects.equals(this.page, operationSquareAnnotation.page) && Objects.equals(this.position, operationSquareAnnotation.position) && Objects.equals(this.printable, operationSquareAnnotation.printable) && Objects.equals(this.rotatable, operationSquareAnnotation.rotatable) && Objects.equals(this.subject, operationSquareAnnotation.subject) && Objects.equals(this.viewable, operationSquareAnnotation.viewable) && Objects.equals(this.writable, operationSquareAnnotation.writable) && Objects.equals(this.zoomable, operationSquareAnnotation.zoomable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.border, this.color, this.contents, this.creator, this.drawMode, this.hidden, this.intents, this.interiorColor, this.invisible, this.locked, this.name, this.opacity, this.page, this.position, this.printable, this.rotatable, this.subject, this.viewable, this.writable, this.zoomable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSquareAnnotation {\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    drawMode: ").append(this.toIndentedString((Object)this.drawMode)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    interiorColor: ").append(this.toIndentedString(this.interiorColor)).append("\n");
        sb.append("    invisible: ").append(this.toIndentedString(this.invisible)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    printable: ").append(this.toIndentedString(this.printable)).append("\n");
        sb.append("    rotatable: ").append(this.toIndentedString(this.rotatable)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    viewable: ").append(this.toIndentedString(this.viewable)).append("\n");
        sb.append("    writable: ").append(this.toIndentedString(this.writable)).append("\n");
        sb.append("    zoomable: ").append(this.toIndentedString(this.zoomable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DrawModeEnum {
        FILL(String.valueOf("fill")),
        STROKE(String.valueOf("stroke")),
        FILL_AND_STROKE(String.valueOf("fillAndStroke"));

        private String value;

        private DrawModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DrawModeEnum fromValue(String value) {
            for (DrawModeEnum b : DrawModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

