/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationKeyPair;
import org.jetbrains.annotations.NotNull;

@Schema(description="Contains a key pair (`<keyPair>`) consisting of the certificate (with public key) and the private key that identifies the signer (`<signer>`) who performs the signature. The certificate and the signer's private key must be passed as a PEM file in `<certificate>` and `<privateKey>` respectively. The element is optional. If no `<keyPair>` (consisting of the certificate and the private key) is passed directly, then a certificate must be selected via `<keyName>`, which is loaded from the server's global keystore.")
@JsonPropertyOrder(value={"keyPair"})
@JsonTypeName(value="Operation_SignerAdd")
public class OperationSignerAdd {
    public static final String JSON_PROPERTY_KEY_PAIR = "keyPair";
    private OperationKeyPair keyPair;

    public OperationSignerAdd keyPair(OperationKeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="keyPair")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationKeyPair getKeyPair() {
        return this.keyPair;
    }

    @JsonProperty(value="keyPair")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeyPair(OperationKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSignerAdd operationSignerAdd = (OperationSignerAdd)o;
        return Objects.equals(this.keyPair, operationSignerAdd.keyPair);
    }

    public int hashCode() {
        return Objects.hash(this.keyPair);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSignerAdd {\n");
        sb.append("    keyPair: ").append(this.toIndentedString(this.keyPair)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

