/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationSignatureFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define an image, for the visual signature, that will be drawn in the signature's background. The image itself is passed with `<data>`.")
@JsonPropertyOrder(value={"data", "opacity", "position"})
@JsonTypeName(value="Operation_SignatureImage")
public class OperationSignatureImage {
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationSignatureFileData data;
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 50;
    public static final String JSON_PROPERTY_POSITION = "position";
    private PositionEnum position = PositionEnum.CENTER;

    public OperationSignatureImage data(OperationSignatureFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationSignatureFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationSignatureFileData data) {
        this.data = data;
    }

    public OperationSignatureImage opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="Opacity of image as a percentage value between 0 and 100.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationSignatureImage position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @Schema(name="Position of image within signature field:  *   center = Centred *   left = Left *   right = Right")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PositionEnum getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSignatureImage operationSignatureImage = (OperationSignatureImage)o;
        return Objects.equals(this.data, operationSignatureImage.data) && Objects.equals(this.opacity, operationSignatureImage.opacity) && Objects.equals((Object)this.position, (Object)operationSignatureImage.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.opacity, this.position});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSignatureImage {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PositionEnum {
        CENTER(String.valueOf("center")),
        LEFT(String.valueOf("left")),
        RIGHT(String.valueOf("right"));

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PositionEnum fromValue(String value) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

