/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define the elements that are part of the visual signature.")
@JsonPropertyOrder(value={"showCommonName", "showCountry", "showDate", "showLocal", "showMail", "showName", "showOrganisationName", "showOrganisationUnit", "showSignedBy", "showState", "textSignedBy"})
@JsonTypeName(value="Operation_SignatureIdentifier")
public class OperationSignatureIdentifier {
    public static final String JSON_PROPERTY_SHOW_COMMON_NAME = "showCommonName";
    private Boolean showCommonName = true;
    public static final String JSON_PROPERTY_SHOW_COUNTRY = "showCountry";
    private Boolean showCountry = true;
    public static final String JSON_PROPERTY_SHOW_DATE = "showDate";
    private Boolean showDate = true;
    public static final String JSON_PROPERTY_SHOW_LOCAL = "showLocal";
    private Boolean showLocal = true;
    public static final String JSON_PROPERTY_SHOW_MAIL = "showMail";
    private Boolean showMail = true;
    public static final String JSON_PROPERTY_SHOW_NAME = "showName";
    private Boolean showName = true;
    public static final String JSON_PROPERTY_SHOW_ORGANISATION_NAME = "showOrganisationName";
    private Boolean showOrganisationName = true;
    public static final String JSON_PROPERTY_SHOW_ORGANISATION_UNIT = "showOrganisationUnit";
    private Boolean showOrganisationUnit = true;
    public static final String JSON_PROPERTY_SHOW_SIGNED_BY = "showSignedBy";
    private Boolean showSignedBy = true;
    public static final String JSON_PROPERTY_SHOW_STATE = "showState";
    private Boolean showState = true;
    public static final String JSON_PROPERTY_TEXT_SIGNED_BY = "textSignedBy";
    private String textSignedBy = "";

    public OperationSignatureIdentifier showCommonName(Boolean showCommonName) {
        this.showCommonName = showCommonName;
        return this;
    }

    @Schema(name="Displays or hides the common name (CN) part of the certificate.")
    @JsonProperty(value="showCommonName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowCommonName() {
        return this.showCommonName;
    }

    @JsonProperty(value="showCommonName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowCommonName(Boolean showCommonName) {
        this.showCommonName = showCommonName;
    }

    public OperationSignatureIdentifier showCountry(Boolean showCountry) {
        this.showCountry = showCountry;
        return this;
    }

    @Schema(name="Displays or hides the (ISO valid) country code (C) of the country in which the certificate holder is located.")
    @JsonProperty(value="showCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowCountry() {
        return this.showCountry;
    }

    @JsonProperty(value="showCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowCountry(Boolean showCountry) {
        this.showCountry = showCountry;
    }

    public OperationSignatureIdentifier showDate(Boolean showDate) {
        this.showDate = showDate;
        return this;
    }

    @Schema(name="Displays or hides the signature time.")
    @JsonProperty(value="showDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowDate() {
        return this.showDate;
    }

    @JsonProperty(value="showDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowDate(Boolean showDate) {
        this.showDate = showDate;
    }

    public OperationSignatureIdentifier showLocal(Boolean showLocal) {
        this.showLocal = showLocal;
        return this;
    }

    @Schema(name="Displays or hides the location/city (L) where the certificate holder is located.")
    @JsonProperty(value="showLocal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowLocal() {
        return this.showLocal;
    }

    @JsonProperty(value="showLocal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowLocal(Boolean showLocal) {
        this.showLocal = showLocal;
    }

    public OperationSignatureIdentifier showMail(Boolean showMail) {
        this.showMail = showMail;
        return this;
    }

    @Schema(name="Displays or hides the email address (E) at which the certificate holder can be contacted.")
    @JsonProperty(value="showMail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowMail() {
        return this.showMail;
    }

    @JsonProperty(value="showMail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowMail(Boolean showMail) {
        this.showMail = showMail;
    }

    public OperationSignatureIdentifier showName(Boolean showName) {
        this.showName = showName;
        return this;
    }

    @Schema(name="Displays or hides the signature `name`. (If `name` has not been set, the common name (CN) part of the certificate is displayed instead.)")
    @JsonProperty(value="showName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowName() {
        return this.showName;
    }

    @JsonProperty(value="showName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowName(Boolean showName) {
        this.showName = showName;
    }

    public OperationSignatureIdentifier showOrganisationName(Boolean showOrganisationName) {
        this.showOrganisationName = showOrganisationName;
        return this;
    }

    @Schema(name="Displays or hides the certificate holder's organization/company (O).")
    @JsonProperty(value="showOrganisationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowOrganisationName() {
        return this.showOrganisationName;
    }

    @JsonProperty(value="showOrganisationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowOrganisationName(Boolean showOrganisationName) {
        this.showOrganisationName = showOrganisationName;
    }

    public OperationSignatureIdentifier showOrganisationUnit(Boolean showOrganisationUnit) {
        this.showOrganisationUnit = showOrganisationUnit;
        return this;
    }

    @Schema(name="Displays or hides the certificate owner's suborganization/department (OU).")
    @JsonProperty(value="showOrganisationUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowOrganisationUnit() {
        return this.showOrganisationUnit;
    }

    @JsonProperty(value="showOrganisationUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowOrganisationUnit(Boolean showOrganisationUnit) {
        this.showOrganisationUnit = showOrganisationUnit;
    }

    public OperationSignatureIdentifier showSignedBy(Boolean showSignedBy) {
        this.showSignedBy = showSignedBy;
        return this;
    }

    @Schema(name="Displays or hides the text `Digitally signed by`. Can be overridden by the value of `textSignedBy`.")
    @JsonProperty(value="showSignedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowSignedBy() {
        return this.showSignedBy;
    }

    @JsonProperty(value="showSignedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowSignedBy(Boolean showSignedBy) {
        this.showSignedBy = showSignedBy;
    }

    public OperationSignatureIdentifier showState(Boolean showState) {
        this.showState = showState;
        return this;
    }

    @Schema(name="Displays or hides the state (S) in which the certificate holder is located.")
    @JsonProperty(value="showState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowState() {
        return this.showState;
    }

    @JsonProperty(value="showState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowState(Boolean showState) {
        this.showState = showState;
    }

    public OperationSignatureIdentifier textSignedBy(String textSignedBy) {
        this.textSignedBy = textSignedBy;
        return this;
    }

    @Schema(name="Text that is displayed when the `showSignedBy` option is enabled. If not set, then the text `Digitally signed by` is used as default.")
    @JsonProperty(value="textSignedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getTextSignedBy() {
        return this.textSignedBy;
    }

    @JsonProperty(value="textSignedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTextSignedBy(String textSignedBy) {
        this.textSignedBy = textSignedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSignatureIdentifier operationSignatureIdentifier = (OperationSignatureIdentifier)o;
        return Objects.equals(this.showCommonName, operationSignatureIdentifier.showCommonName) && Objects.equals(this.showCountry, operationSignatureIdentifier.showCountry) && Objects.equals(this.showDate, operationSignatureIdentifier.showDate) && Objects.equals(this.showLocal, operationSignatureIdentifier.showLocal) && Objects.equals(this.showMail, operationSignatureIdentifier.showMail) && Objects.equals(this.showName, operationSignatureIdentifier.showName) && Objects.equals(this.showOrganisationName, operationSignatureIdentifier.showOrganisationName) && Objects.equals(this.showOrganisationUnit, operationSignatureIdentifier.showOrganisationUnit) && Objects.equals(this.showSignedBy, operationSignatureIdentifier.showSignedBy) && Objects.equals(this.showState, operationSignatureIdentifier.showState) && Objects.equals(this.textSignedBy, operationSignatureIdentifier.textSignedBy);
    }

    public int hashCode() {
        return Objects.hash(this.showCommonName, this.showCountry, this.showDate, this.showLocal, this.showMail, this.showName, this.showOrganisationName, this.showOrganisationUnit, this.showSignedBy, this.showState, this.textSignedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSignatureIdentifier {\n");
        sb.append("    showCommonName: ").append(this.toIndentedString(this.showCommonName)).append("\n");
        sb.append("    showCountry: ").append(this.toIndentedString(this.showCountry)).append("\n");
        sb.append("    showDate: ").append(this.toIndentedString(this.showDate)).append("\n");
        sb.append("    showLocal: ").append(this.toIndentedString(this.showLocal)).append("\n");
        sb.append("    showMail: ").append(this.toIndentedString(this.showMail)).append("\n");
        sb.append("    showName: ").append(this.toIndentedString(this.showName)).append("\n");
        sb.append("    showOrganisationName: ").append(this.toIndentedString(this.showOrganisationName)).append("\n");
        sb.append("    showOrganisationUnit: ").append(this.toIndentedString(this.showOrganisationUnit)).append("\n");
        sb.append("    showSignedBy: ").append(this.toIndentedString(this.showSignedBy)).append("\n");
        sb.append("    showState: ").append(this.toIndentedString(this.showState)).append("\n");
        sb.append("    textSignedBy: ").append(this.toIndentedString(this.textSignedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

