/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to set an area from which attachments that meet the selection rules will be removed. You can use multiple selection elements.")
@JsonPropertyOrder(value={"context", "fileMask", "pages"})
@JsonTypeName(value="Operation_SelectionAttachment")
public class OperationSelectionAttachment {
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private ContextEnum context = ContextEnum.ALL;
    public static final String JSON_PROPERTY_FILE_MASK = "fileMask";
    private String fileMask = "";
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";

    public OperationSelectionAttachment context(ContextEnum context) {
        this.context = context;
        return this;
    }

    @Schema(name="Level to which the selection applies.  *   all = All levels *   document = Document level only *   page = Page level only")
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ContextEnum getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(ContextEnum context) {
        this.context = context;
    }

    public OperationSelectionAttachment fileMask(String fileMask) {
        this.fileMask = fileMask;
        return this;
    }

    @Schema(name="Filters by file name for the selection. \"\\*.xls\", for example, would result in all XLS attachments in the selection area being removed. Meanwhile, \"xyz.json\" would result in attachments named \"xyz.json\" being removed from the selection area.")
    @JsonProperty(value="fileMask")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileMask() {
        return this.fileMask;
    }

    @JsonProperty(value="fileMask")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public OperationSelectionAttachment pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Page range to which the selection applies.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSelectionAttachment operationSelectionAttachment = (OperationSelectionAttachment)o;
        return Objects.equals((Object)this.context, (Object)operationSelectionAttachment.context) && Objects.equals(this.fileMask, operationSelectionAttachment.fileMask) && Objects.equals(this.pages, operationSelectionAttachment.pages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.fileMask, this.pages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSelectionAttachment {\n");
        sb.append("    context: ").append(this.toIndentedString((Object)this.context)).append("\n");
        sb.append("    fileMask: ").append(this.toIndentedString(this.fileMask)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContextEnum {
        PAGE(String.valueOf("page")),
        DOCUMENT(String.valueOf("document")),
        ALL(String.valueOf("all"));

        private String value;

        private ContextEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContextEnum fromValue(String value) {
            for (ContextEnum b : ContextEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

