/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to select a rectangle.")
@JsonPropertyOrder(value={"coordinates", "height", "metrics", "width", "x", "y"})
@JsonTypeName(value="Operation_Rectangle")
public class OperationRectangle {
    public static final String JSON_PROPERTY_COORDINATES = "coordinates";
    private CoordinatesEnum coordinates = CoordinatesEnum.USER;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Float height = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_X = "x";
    private Float x = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_Y = "y";
    private Float y = Float.valueOf(0.0f);

    public OperationRectangle coordinates(CoordinatesEnum coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @Schema(name="Used to define the coordinate system and, accordingly, the origin for the position arguments.  *   user = User coordinate system (origin at top left) *   pdf = PDF coordinate system (origin at bottom left)")
    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CoordinatesEnum getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoordinates(CoordinatesEnum coordinates) {
        this.coordinates = coordinates;
    }

    public OperationRectangle height(Float height) {
        this.height = height;
        return this;
    }

    @Schema(name="Height of the rectangle.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Float height) {
        this.height = height;
    }

    public OperationRectangle metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationRectangle width(Float width) {
        this.width = width;
        return this;
    }

    @Schema(name="Width of the rectangle.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public OperationRectangle x(Float x) {
        this.x = x;
        return this;
    }

    @Schema(name="X-axis position.")
    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getX() {
        return this.x;
    }

    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX(Float x) {
        this.x = x;
    }

    public OperationRectangle y(Float y) {
        this.y = y;
        return this;
    }

    @Schema(name="Y-axis position.")
    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getY() {
        return this.y;
    }

    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setY(Float y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationRectangle operationRectangle = (OperationRectangle)o;
        return Objects.equals((Object)this.coordinates, (Object)operationRectangle.coordinates) && Objects.equals(this.height, operationRectangle.height) && Objects.equals((Object)this.metrics, (Object)operationRectangle.metrics) && Objects.equals(this.width, operationRectangle.width) && Objects.equals(this.x, operationRectangle.x) && Objects.equals(this.y, operationRectangle.y);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.coordinates, this.height, this.metrics, this.width, this.x, this.y});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationRectangle {\n");
        sb.append("    coordinates: ").append(this.toIndentedString((Object)this.coordinates)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        PT(String.valueOf("pt")),
        PC(String.valueOf("pc")),
        PX(String.valueOf("px")),
        MM(String.valueOf("mm")),
        IN(String.valueOf("in"));

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CoordinatesEnum {
        PDF(String.valueOf("pdf")),
        USER(String.valueOf("user"));

        private String value;

        private CoordinatesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CoordinatesEnum fromValue(String value) {
            for (CoordinatesEnum b : CoordinatesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

