/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPoint;
import org.jetbrains.annotations.Nullable;

@Schema(description="Selects a rectangular area via it's 4 determining corner points.  **important:** The quadrilateral's points shall be defined in the clockwise order: top-left, top-right, bottom-right, bottom-left  **important:** Even though the PDF standard defines algorithms, that can handle self intersecting and overlapping quadrilaterals, such should be avoided to prevent unexpected results.")
@JsonPropertyOrder(value={"point"})
@JsonTypeName(value="Operation_Quadrilateral")
public class OperationQuadrilateral {
    public static final String JSON_PROPERTY_POINT = "point";
    private List<OperationPoint> point = null;

    public OperationQuadrilateral point(List<OperationPoint> point) {
        this.point = point;
        return this;
    }

    public OperationQuadrilateral addPointItem(OperationPoint pointItem) {
        if (this.point == null) {
            this.point = new ArrayList<OperationPoint>();
        }
        this.point.add(pointItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="point")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationPoint> getPoint() {
        return this.point;
    }

    @JsonProperty(value="point")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPoint(List<OperationPoint> point) {
        this.point = point;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationQuadrilateral operationQuadrilateral = (OperationQuadrilateral)o;
        return Objects.equals(this.point, operationQuadrilateral.point);
    }

    public int hashCode() {
        return Objects.hash(this.point);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationQuadrilateral {\n");
        sb.append("    point: ").append(this.toIndentedString(this.point)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

