/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to select documents that match the selection rules and that should be processed (extracted / deleted) accordingly. You can use multiple selection elements.")
@JsonPropertyOrder(value={"fileName", "path"})
@JsonTypeName(value="Operation_PortfolioSelection")
public class OperationPortfolioSelection {
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_PATH = "path";
    private String path = "";

    public OperationPortfolioSelection fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="Filters by file name for the selection. \"\\*.xls\", for example, would result in all XLS documents being selected. Meanwhile, \"xyz.json\" would result in attachments named \"xyz.json\" being selected (for extraction / deletion).  **Important:** The \"path\" and \"fileName\" parameters follow and implement the glob selection patterns for files and paths.")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public OperationPortfolioSelection path(String path) {
        this.path = path;
        return this;
    }

    @Schema(name="Filters by path for the selection. \"a/b/\\*\", for example, would result in all a/b subfolders being searched for matching documents. Whether a document will be considered a match will also depend on the \"fileName\" parameter. If the \"fileName\" parameter is not set, this parameter can be used to select the path instead (for extraction / deletion)")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPortfolioSelection operationPortfolioSelection = (OperationPortfolioSelection)o;
        return Objects.equals(this.fileName, operationPortfolioSelection.fileName) && Objects.equals(this.path, operationPortfolioSelection.path);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPortfolioSelection {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

