/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPortfolioFile;
import net.webpdf.wsclient.openapi.OperationPortfolioFolder;
import org.jetbrains.annotations.Nullable;

@Schema(description="Adds a document to the portfolio.")
@JsonPropertyOrder(value={"file", "folder", "initialDocumentPath", "initialFileName"})
@JsonTypeName(value="Operation_PortfolioAdd")
public class OperationPortfolioAdd {
    public static final String JSON_PROPERTY_FILE = "file";
    private List<OperationPortfolioFile> _file = null;
    public static final String JSON_PROPERTY_FOLDER = "folder";
    private List<OperationPortfolioFolder> folder = null;
    public static final String JSON_PROPERTY_INITIAL_DOCUMENT_PATH = "initialDocumentPath";
    private String initialDocumentPath = "";
    public static final String JSON_PROPERTY_INITIAL_FILE_NAME = "initialFileName";
    private String initialFileName = "";

    public OperationPortfolioAdd _file(List<OperationPortfolioFile> _file) {
        this._file = _file;
        return this;
    }

    public OperationPortfolioAdd addFileItem(OperationPortfolioFile _fileItem) {
        if (this._file == null) {
            this._file = new ArrayList<OperationPortfolioFile>();
        }
        this._file.add(_fileItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationPortfolioFile> getFile() {
        return this._file;
    }

    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFile(List<OperationPortfolioFile> _file) {
        this._file = _file;
    }

    public OperationPortfolioAdd folder(List<OperationPortfolioFolder> folder) {
        this.folder = folder;
        return this;
    }

    public OperationPortfolioAdd addFolderItem(OperationPortfolioFolder folderItem) {
        if (this.folder == null) {
            this.folder = new ArrayList<OperationPortfolioFolder>();
        }
        this.folder.add(folderItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="folder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationPortfolioFolder> getFolder() {
        return this.folder;
    }

    @JsonProperty(value="folder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolder(List<OperationPortfolioFolder> folder) {
        this.folder = folder;
    }

    public OperationPortfolioAdd initialDocumentPath(String initialDocumentPath) {
        this.initialDocumentPath = initialDocumentPath;
        return this;
    }

    @Schema(name="Defines the path/folder where the initially shown document is stored in the portfolio.  **Important:** The \"path\" and \"fileName\" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by \"/\" separated nested folder names.")
    @JsonProperty(value="initialDocumentPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInitialDocumentPath() {
        return this.initialDocumentPath;
    }

    @JsonProperty(value="initialDocumentPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialDocumentPath(String initialDocumentPath) {
        this.initialDocumentPath = initialDocumentPath;
    }

    public OperationPortfolioAdd initialFileName(String initialFileName) {
        this.initialFileName = initialFileName;
        return this;
    }

    @Schema(name="Select the name of the initially shown document.  **Important:** The \"path\" and \"fileName\" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by \"/\" separated nested folder names.")
    @JsonProperty(value="initialFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInitialFileName() {
        return this.initialFileName;
    }

    @JsonProperty(value="initialFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialFileName(String initialFileName) {
        this.initialFileName = initialFileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPortfolioAdd operationPortfolioAdd = (OperationPortfolioAdd)o;
        return Objects.equals(this._file, operationPortfolioAdd._file) && Objects.equals(this.folder, operationPortfolioAdd.folder) && Objects.equals(this.initialDocumentPath, operationPortfolioAdd.initialDocumentPath) && Objects.equals(this.initialFileName, operationPortfolioAdd.initialFileName);
    }

    public int hashCode() {
        return Objects.hash(this._file, this.folder, this.initialDocumentPath, this.initialFileName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPortfolioAdd {\n");
        sb.append("    _file: ").append(this.toIndentedString(this._file)).append("\n");
        sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        sb.append("    initialDocumentPath: ").append(this.toIndentedString(this.initialDocumentPath)).append("\n");
        sb.append("    initialFileName: ").append(this.toIndentedString(this.initialFileName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

