/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to set the password for encryption and the encryption key length.")
@JsonPropertyOrder(value={"encryptionKey", "open", "permission"})
@JsonTypeName(value="Operation_PasswordEncrypt")
public class OperationPasswordEncrypt {
    public static final String JSON_PROPERTY_ENCRYPTION_KEY = "encryptionKey";
    private EncryptionKeyEnum encryptionKey = EncryptionKeyEnum.RC4_128;
    public static final String JSON_PROPERTY_OPEN = "open";
    private String open = "";
    public static final String JSON_PROPERTY_PERMISSION = "permission";
    private String permission = "";

    public OperationPasswordEncrypt encryptionKey(EncryptionKeyEnum encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Schema(name="Sets the encryption level for the document.  *   RC4\\_40 = 40-bit RC4 *   RC4\\_128 = 128-bit RC4 *   AES\\_128 = 128-bit AES *   AES\\_256 = 256-bit AES  **Important:** Please note that the option \"256-bit AES\" only works if the \"Java Cryptography Extension (JCE)\" has been enabled with \"Unlimited Strength\" in the JVM. You can obtain the modified \"Policy Files\" (along with instructions for installation) from the Oracle website: Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download: http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html")
    @JsonProperty(value="encryptionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public EncryptionKeyEnum getEncryptionKey() {
        return this.encryptionKey;
    }

    @JsonProperty(value="encryptionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptionKey(EncryptionKeyEnum encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public OperationPasswordEncrypt open(String open) {
        this.open = open;
        return this;
    }

    @Schema(name="Used to set the password that will be requested if the PDF document is opened for reading.")
    @JsonProperty(value="open")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOpen() {
        return this.open;
    }

    @JsonProperty(value="open")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpen(String open) {
        this.open = open;
    }

    public OperationPasswordEncrypt permission(String permission) {
        this.permission = permission;
        return this;
    }

    @Schema(name="Used to set the password that will be requested if the file is opened for editing (e.g., when removing pages). The password is required to enable the individual access permissions and must not be blank if the access permissions are to be used.  **Important:** Please note that the password and the associated access permissions will only provide protection if an appropriate display program for PDF documents takes these settings into account.")
    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPasswordEncrypt operationPasswordEncrypt = (OperationPasswordEncrypt)o;
        return Objects.equals((Object)this.encryptionKey, (Object)operationPasswordEncrypt.encryptionKey) && Objects.equals(this.open, operationPasswordEncrypt.open) && Objects.equals(this.permission, operationPasswordEncrypt.permission);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.encryptionKey, this.open, this.permission});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPasswordEncrypt {\n");
        sb.append("    encryptionKey: ").append(this.toIndentedString((Object)this.encryptionKey)).append("\n");
        sb.append("    open: ").append(this.toIndentedString(this.open)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EncryptionKeyEnum {
        RC4_40(String.valueOf("RC4_40")),
        RC4_128(String.valueOf("RC4_128")),
        AES_128(String.valueOf("AES_128")),
        AES_256(String.valueOf("AES_256"));

        private String value;

        private EncryptionKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionKeyEnum fromValue(String value) {
            for (EncryptionKeyEnum b : EncryptionKeyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

