/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The executeNamed action executes a prepared action that is known to the reader application with a specific name. There are certain standard actions that should be known to any reader application. However, an application can have other defined names as well. The actions' execution and what it does are defined exclusively by the reader application, meaning that the resulting behaviour can vary completely from one application to another.")
@JsonPropertyOrder(value={"namedOperation"})
@JsonTypeName(value="Operation_NamedAction_executeNamed")
public class OperationNamedActionExecuteNamed {
    public static final String JSON_PROPERTY_NAMED_OPERATION = "namedOperation";
    private String namedOperation = "";

    public OperationNamedActionExecuteNamed namedOperation(String namedOperation) {
        this.namedOperation = namedOperation;
        return this;
    }

    @Schema(name="The name of the action that should be run. The following are standard names that any reader application should know:  *   NextPage = Jumps to the next page *   PrevPage = Jumps to the previous page *   FirstPage = Jump to the first page *   LastPage = Jump to the last page")
    @JsonProperty(value="namedOperation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getNamedOperation() {
        return this.namedOperation;
    }

    @JsonProperty(value="namedOperation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamedOperation(String namedOperation) {
        this.namedOperation = namedOperation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationNamedActionExecuteNamed operationNamedActionExecuteNamed = (OperationNamedActionExecuteNamed)o;
        return Objects.equals(this.namedOperation, operationNamedActionExecuteNamed.namedOperation);
    }

    public int hashCode() {
        return Objects.hash(this.namedOperation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationNamedActionExecuteNamed {\n");
        sb.append("    namedOperation: ").append(this.toIndentedString(this.namedOperation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

