/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="An annotation, that provides a \"marked state\" for a selected annotation.")
@JsonPropertyOrder(value={"creator", "markedState", "name", "page", "replyTo", "subject"})
@JsonTypeName(value="Operation_MarkedStateAnnotation")
public class OperationMarkedStateAnnotation {
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_MARKED_STATE = "markedState";
    private Boolean markedState = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_REPLY_TO = "replyTo";
    private String replyTo = "";
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";

    public OperationMarkedStateAnnotation creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationMarkedStateAnnotation markedState(Boolean markedState) {
        this.markedState = markedState;
        return this;
    }

    @Schema(name="Marks or unmarks the annotated note.")
    @JsonProperty(value="markedState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getMarkedState() {
        return this.markedState;
    }

    @JsonProperty(value="markedState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkedState(Boolean markedState) {
        this.markedState = markedState;
    }

    public OperationMarkedStateAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationMarkedStateAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Set the number of the page, the annotation shall be placed on.  **Important:** A reply shall always be placed on the same page as it's target annotation. This is mostly providing a hint where to find the selected annotation.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationMarkedStateAnnotation replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Schema(name="Selects the object id of the annotation, that this annotation shall be a reply to. The object id shall be given as a String that may contain either:  *   The numeric object ID itself *   The object ID followed by the generation number, separated by a space")
    @JsonProperty(value="replyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getReplyTo() {
        return this.replyTo;
    }

    @JsonProperty(value="replyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public OperationMarkedStateAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationMarkedStateAnnotation operationMarkedStateAnnotation = (OperationMarkedStateAnnotation)o;
        return Objects.equals(this.creator, operationMarkedStateAnnotation.creator) && Objects.equals(this.markedState, operationMarkedStateAnnotation.markedState) && Objects.equals(this.name, operationMarkedStateAnnotation.name) && Objects.equals(this.page, operationMarkedStateAnnotation.page) && Objects.equals(this.replyTo, operationMarkedStateAnnotation.replyTo) && Objects.equals(this.subject, operationMarkedStateAnnotation.subject);
    }

    public int hashCode() {
        return Objects.hash(this.creator, this.markedState, this.name, this.page, this.replyTo, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationMarkedStateAnnotation {\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    markedState: ").append(this.toIndentedString(this.markedState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

