/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to export data from the form fields.")
@JsonPropertyOrder(value={"fdfFileName", "format"})
@JsonTypeName(value="Operation_FormsExport")
public class OperationFormsExport {
    public static final String JSON_PROPERTY_FDF_FILE_NAME = "fdfFileName";
    private String fdfFileName = "";
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format = FormatEnum.XML;

    public OperationFormsExport fdfFileName(String fdfFileName) {
        this.fdfFileName = fdfFileName;
        return this;
    }

    @Schema(name="Used to specify the file name of the PDF document that should be loaded automatically when the FDF document is opened. This setting is only used if \"format\" is set to \"fdf\".")
    @JsonProperty(value="fdfFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFdfFileName() {
        return this.fdfFileName;
    }

    @JsonProperty(value="fdfFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFdfFileName(String fdfFileName) {
        this.fdfFileName = fdfFileName;
    }

    public OperationFormsExport format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Schema(name="Used to set the format for exporting the data in a PDF form:  *   xml = XML *   fdf = FDF *   xfdf = XFDF *   xdp = XDP (only for PDF documents that contain XFA data)  The exported data will be returned with the web service call as per the selected format.  **Tip:** The format of this is described by the http://schema.webpdf.de/1.0/form/data.xsd schema.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFormsExport operationFormsExport = (OperationFormsExport)o;
        return Objects.equals(this.fdfFileName, operationFormsExport.fdfFileName) && Objects.equals((Object)this.format, (Object)operationFormsExport.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fdfFileName, this.format});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFormsExport {\n");
        sb.append("    fdfFileName: ").append(this.toIndentedString(this.fdfFileName)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        XML(String.valueOf("xml")),
        FDF(String.valueOf("fdf")),
        XFDF(String.valueOf("xfdf")),
        XDP(String.valueOf("xdp"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

