/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationAttachmentFileData;
import net.webpdf.wsclient.openapi.OperationFileAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define an individual file attachment that should be added to the PDF document. This element can be used multiple times if you want to add multiple files.")
@JsonPropertyOrder(value={"annotation", "creator", "data", "fileName", "mimeType"})
@JsonTypeName(value="Operation_FileAttachment")
public class OperationFileAttachment {
    public static final String JSON_PROPERTY_ANNOTATION = "annotation";
    private OperationFileAnnotation annotation;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationAttachmentFileData data;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
    private String mimeType = "";

    public OperationFileAttachment annotation(OperationFileAnnotation annotation) {
        this.annotation = annotation;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="annotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationFileAnnotation getAnnotation() {
        return this.annotation;
    }

    @JsonProperty(value="annotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnotation(OperationFileAnnotation annotation) {
        this.annotation = annotation;
    }

    public OperationFileAttachment creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Can be used to set an author for the attachment. If you leave this value blank, the currently active system user will be used.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationFileAttachment data(OperationAttachmentFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationAttachmentFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationAttachmentFileData data) {
        this.data = data;
    }

    public OperationFileAttachment fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(required=true, name="Used to define the name under which the attachment in the document will be created.")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public OperationFileAttachment mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(name="Can be used to set an optional MIME data type for the attachment. If you leave this value blank, the \"application/octet-stream\" MIME data type will be used.")
    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFileAttachment operationFileAttachment = (OperationFileAttachment)o;
        return Objects.equals(this.annotation, operationFileAttachment.annotation) && Objects.equals(this.creator, operationFileAttachment.creator) && Objects.equals(this.data, operationFileAttachment.data) && Objects.equals(this.fileName, operationFileAttachment.fileName) && Objects.equals(this.mimeType, operationFileAttachment.mimeType);
    }

    public int hashCode() {
        return Objects.hash(this.annotation, this.creator, this.data, this.fileName, this.mimeType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFileAttachment {\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

