/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPasswordEncrypt;
import org.jetbrains.annotations.Nullable;

@Schema(description="These parameters can be used to set encryption for a PDF document.")
@JsonPropertyOrder(value={"canAssemble", "canExtractContent", "canExtractForAccessibility", "canFillInForm", "canModify", "canModifyAnnotations", "canPrint", "canPrintHighRes", "contentEncryption", "password"})
@JsonTypeName(value="Operation_Encrypt")
public class OperationEncrypt {
    public static final String JSON_PROPERTY_CAN_ASSEMBLE = "canAssemble";
    private Boolean canAssemble = false;
    public static final String JSON_PROPERTY_CAN_EXTRACT_CONTENT = "canExtractContent";
    private Boolean canExtractContent = false;
    public static final String JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY = "canExtractForAccessibility";
    private Boolean canExtractForAccessibility = false;
    public static final String JSON_PROPERTY_CAN_FILL_IN_FORM = "canFillInForm";
    private Boolean canFillInForm = false;
    public static final String JSON_PROPERTY_CAN_MODIFY = "canModify";
    private Boolean canModify = false;
    public static final String JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS = "canModifyAnnotations";
    private Boolean canModifyAnnotations = false;
    public static final String JSON_PROPERTY_CAN_PRINT = "canPrint";
    private Boolean canPrint = false;
    public static final String JSON_PROPERTY_CAN_PRINT_HIGH_RES = "canPrintHighRes";
    private Boolean canPrintHighRes = false;
    public static final String JSON_PROPERTY_CONTENT_ENCRYPTION = "contentEncryption";
    private ContentEncryptionEnum contentEncryption = ContentEncryptionEnum.ENCRYPT_EVERYTHING;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private OperationPasswordEncrypt password;

    public OperationEncrypt canAssemble(Boolean canAssemble) {
        this.canAssemble = canAssemble;
        return this;
    }

    @Schema(name="If \"true,\" the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).")
    @JsonProperty(value="canAssemble")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanAssemble() {
        return this.canAssemble;
    }

    @JsonProperty(value="canAssemble")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanAssemble(Boolean canAssemble) {
        this.canAssemble = canAssemble;
    }

    public OperationEncrypt canExtractContent(Boolean canExtractContent) {
        this.canExtractContent = canExtractContent;
        return this;
    }

    @Schema(name="If \"true,\" content can be extracted (copied) from the document.")
    @JsonProperty(value="canExtractContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanExtractContent() {
        return this.canExtractContent;
    }

    @JsonProperty(value="canExtractContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanExtractContent(Boolean canExtractContent) {
        this.canExtractContent = canExtractContent;
    }

    public OperationEncrypt canExtractForAccessibility(Boolean canExtractForAccessibility) {
        this.canExtractForAccessibility = canExtractForAccessibility;
        return this;
    }

    @Schema(name="If \"true,\" content can be extracted (copied) for accessibility purposes.")
    @JsonProperty(value="canExtractForAccessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanExtractForAccessibility() {
        return this.canExtractForAccessibility;
    }

    @JsonProperty(value="canExtractForAccessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanExtractForAccessibility(Boolean canExtractForAccessibility) {
        this.canExtractForAccessibility = canExtractForAccessibility;
    }

    public OperationEncrypt canFillInForm(Boolean canFillInForm) {
        this.canFillInForm = canFillInForm;
        return this;
    }

    @Schema(name="If \"true,\" form fields can be filled out and the document can be signed.")
    @JsonProperty(value="canFillInForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanFillInForm() {
        return this.canFillInForm;
    }

    @JsonProperty(value="canFillInForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanFillInForm(Boolean canFillInForm) {
        this.canFillInForm = canFillInForm;
    }

    public OperationEncrypt canModify(Boolean canModify) {
        this.canModify = canModify;
        return this;
    }

    @Schema(name="If \"true,\" changes to the document are permitted.")
    @JsonProperty(value="canModify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanModify() {
        return this.canModify;
    }

    @JsonProperty(value="canModify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanModify(Boolean canModify) {
        this.canModify = canModify;
    }

    public OperationEncrypt canModifyAnnotations(Boolean canModifyAnnotations) {
        this.canModifyAnnotations = canModifyAnnotations;
        return this;
    }

    @Schema(name="If \"true,\" comments can be added to the document and deleted from the document.")
    @JsonProperty(value="canModifyAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanModifyAnnotations() {
        return this.canModifyAnnotations;
    }

    @JsonProperty(value="canModifyAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanModifyAnnotations(Boolean canModifyAnnotations) {
        this.canModifyAnnotations = canModifyAnnotations;
    }

    public OperationEncrypt canPrint(Boolean canPrint) {
        this.canPrint = canPrint;
        return this;
    }

    @Schema(name="If \"true,\" the document can be printed.")
    @JsonProperty(value="canPrint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanPrint() {
        return this.canPrint;
    }

    @JsonProperty(value="canPrint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanPrint(Boolean canPrint) {
        this.canPrint = canPrint;
    }

    public OperationEncrypt canPrintHighRes(Boolean canPrintHighRes) {
        this.canPrintHighRes = canPrintHighRes;
        return this;
    }

    @Schema(name="If \"true,\" the document can be printed at high resolution levels.")
    @JsonProperty(value="canPrintHighRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanPrintHighRes() {
        return this.canPrintHighRes;
    }

    @JsonProperty(value="canPrintHighRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanPrintHighRes(Boolean canPrintHighRes) {
        this.canPrintHighRes = canPrintHighRes;
    }

    public OperationEncrypt contentEncryption(ContentEncryptionEnum contentEncryption) {
        this.contentEncryption = contentEncryption;
        return this;
    }

    @Schema(name="Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).")
    @JsonProperty(value="contentEncryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ContentEncryptionEnum getContentEncryption() {
        return this.contentEncryption;
    }

    @JsonProperty(value="contentEncryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentEncryption(ContentEncryptionEnum contentEncryption) {
        this.contentEncryption = contentEncryption;
    }

    public OperationEncrypt password(OperationPasswordEncrypt password) {
        this.password = password;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPasswordEncrypt getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(OperationPasswordEncrypt password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationEncrypt operationEncrypt = (OperationEncrypt)o;
        return Objects.equals(this.canAssemble, operationEncrypt.canAssemble) && Objects.equals(this.canExtractContent, operationEncrypt.canExtractContent) && Objects.equals(this.canExtractForAccessibility, operationEncrypt.canExtractForAccessibility) && Objects.equals(this.canFillInForm, operationEncrypt.canFillInForm) && Objects.equals(this.canModify, operationEncrypt.canModify) && Objects.equals(this.canModifyAnnotations, operationEncrypt.canModifyAnnotations) && Objects.equals(this.canPrint, operationEncrypt.canPrint) && Objects.equals(this.canPrintHighRes, operationEncrypt.canPrintHighRes) && Objects.equals((Object)this.contentEncryption, (Object)operationEncrypt.contentEncryption) && Objects.equals(this.password, operationEncrypt.password);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.canAssemble, this.canExtractContent, this.canExtractForAccessibility, this.canFillInForm, this.canModify, this.canModifyAnnotations, this.canPrint, this.canPrintHighRes, this.contentEncryption, this.password});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationEncrypt {\n");
        sb.append("    canAssemble: ").append(this.toIndentedString(this.canAssemble)).append("\n");
        sb.append("    canExtractContent: ").append(this.toIndentedString(this.canExtractContent)).append("\n");
        sb.append("    canExtractForAccessibility: ").append(this.toIndentedString(this.canExtractForAccessibility)).append("\n");
        sb.append("    canFillInForm: ").append(this.toIndentedString(this.canFillInForm)).append("\n");
        sb.append("    canModify: ").append(this.toIndentedString(this.canModify)).append("\n");
        sb.append("    canModifyAnnotations: ").append(this.toIndentedString(this.canModifyAnnotations)).append("\n");
        sb.append("    canPrint: ").append(this.toIndentedString(this.canPrint)).append("\n");
        sb.append("    canPrintHighRes: ").append(this.toIndentedString(this.canPrintHighRes)).append("\n");
        sb.append("    contentEncryption: ").append(this.toIndentedString((Object)this.contentEncryption)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContentEncryptionEnum {
        ENCRYPT_EVERYTHING(String.valueOf("encryptEverything")),
        EXPOSE_METADATA(String.valueOf("exposeMetadata"));

        private String value;

        private ContentEncryptionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentEncryptionEnum fromValue(String value) {
            for (ContentEncryptionEnum b : ContentEncryptionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

