/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationBarcodeSelection;
import org.jetbrains.annotations.Nullable;

@Schema(description="This operation is used to define the barcode recognition parameters. The system will attempt to find barcodes inside the area defined with `<scanArea>`. The recognition process itself is controlled with `<selection>`.")
@JsonPropertyOrder(value={"inputFormat", "outputFormat", "selection"})
@JsonTypeName(value="Operation_DetectBarcode")
public class OperationDetectBarcode {
    public static final String JSON_PROPERTY_INPUT_FORMAT = "inputFormat";
    private InputFormatEnum inputFormat = InputFormatEnum.PDF;
    public static final String JSON_PROPERTY_OUTPUT_FORMAT = "outputFormat";
    private OutputFormatEnum outputFormat = OutputFormatEnum.JSON;
    public static final String JSON_PROPERTY_SELECTION = "selection";
    private List<OperationBarcodeSelection> selection = null;

    public OperationDetectBarcode inputFormat(InputFormatEnum inputFormat) {
        this.inputFormat = inputFormat;
        return this;
    }

    @Schema(name="Used to select the format of the file with the contents that will be scanned for barcodes.  *   pdf = PDF document *   img = Image document (JPG, PNG, TIF)")
    @JsonProperty(value="inputFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public InputFormatEnum getInputFormat() {
        return this.inputFormat;
    }

    @JsonProperty(value="inputFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputFormat(InputFormatEnum inputFormat) {
        this.inputFormat = inputFormat;
    }

    public OperationDetectBarcode outputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Schema(name="Used to select the format in which the recognition results should be returned.  *   json = JSON *   xml = XML")
    @JsonProperty(value="outputFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    @JsonProperty(value="outputFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }

    public OperationDetectBarcode selection(List<OperationBarcodeSelection> selection) {
        this.selection = selection;
        return this;
    }

    public OperationDetectBarcode addSelectionItem(OperationBarcodeSelection selectionItem) {
        if (this.selection == null) {
            this.selection = new ArrayList<OperationBarcodeSelection>();
        }
        this.selection.add(selectionItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationBarcodeSelection> getSelection() {
        return this.selection;
    }

    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelection(List<OperationBarcodeSelection> selection) {
        this.selection = selection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDetectBarcode operationDetectBarcode = (OperationDetectBarcode)o;
        return Objects.equals((Object)this.inputFormat, (Object)operationDetectBarcode.inputFormat) && Objects.equals((Object)this.outputFormat, (Object)operationDetectBarcode.outputFormat) && Objects.equals(this.selection, operationDetectBarcode.selection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputFormat, this.outputFormat, this.selection});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationDetectBarcode {\n");
        sb.append("    inputFormat: ").append(this.toIndentedString((Object)this.inputFormat)).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString((Object)this.outputFormat)).append("\n");
        sb.append("    selection: ").append(this.toIndentedString(this.selection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OutputFormatEnum {
        XML(String.valueOf("xml")),
        JSON(String.valueOf("json"));

        private String value;

        private OutputFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OutputFormatEnum fromValue(String value) {
            for (OutputFormatEnum b : OutputFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InputFormatEnum {
        PDF(String.valueOf("pdf")),
        IMG(String.valueOf("img"));

        private String value;

        private InputFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InputFormatEnum fromValue(String value) {
            for (InputFormatEnum b : InputFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

