/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationSyntaxHighlight;
import net.webpdf.wsclient.openapi.OperationTextHighlight;
import org.jetbrains.annotations.Nullable;

@Schema(description="The settings are used in purely text-based files that can contain source code that would make syntax highlighting advisable. If you configure this element, the system will attempt, during conversion, to detect whether and in which programming/script language content is stored. Based on the result, it will then determine the type of highlighting (in the generated PDF document) is required. SyntaxHighlighter and TextHighlighter are specified alternately. If the syntax highlighter is unable to determine whether the contents belong to any language it knows, the text highlighter will be used instead for formatting.")
@JsonPropertyOrder(value={"syntaxHighlight", "textHighlight", "useSyntaxDetection"})
@JsonTypeName(value="Operation_ConverterText")
public class OperationConverterText {
    public static final String JSON_PROPERTY_SYNTAX_HIGHLIGHT = "syntaxHighlight";
    private OperationSyntaxHighlight syntaxHighlight;
    public static final String JSON_PROPERTY_TEXT_HIGHLIGHT = "textHighlight";
    private OperationTextHighlight textHighlight;
    public static final String JSON_PROPERTY_USE_SYNTAX_DETECTION = "useSyntaxDetection";
    private Boolean useSyntaxDetection = false;

    public OperationConverterText syntaxHighlight(OperationSyntaxHighlight syntaxHighlight) {
        this.syntaxHighlight = syntaxHighlight;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="syntaxHighlight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationSyntaxHighlight getSyntaxHighlight() {
        return this.syntaxHighlight;
    }

    @JsonProperty(value="syntaxHighlight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyntaxHighlight(OperationSyntaxHighlight syntaxHighlight) {
        this.syntaxHighlight = syntaxHighlight;
    }

    public OperationConverterText textHighlight(OperationTextHighlight textHighlight) {
        this.textHighlight = textHighlight;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="textHighlight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationTextHighlight getTextHighlight() {
        return this.textHighlight;
    }

    @JsonProperty(value="textHighlight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTextHighlight(OperationTextHighlight textHighlight) {
        this.textHighlight = textHighlight;
    }

    public OperationConverterText useSyntaxDetection(Boolean useSyntaxDetection) {
        this.useSyntaxDetection = useSyntaxDetection;
        return this;
    }

    @Schema(name="If this value is set to \"true\", syntax highlighting and language detection will be enabled.")
    @JsonProperty(value="useSyntaxDetection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseSyntaxDetection() {
        return this.useSyntaxDetection;
    }

    @JsonProperty(value="useSyntaxDetection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseSyntaxDetection(Boolean useSyntaxDetection) {
        this.useSyntaxDetection = useSyntaxDetection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterText operationConverterText = (OperationConverterText)o;
        return Objects.equals(this.syntaxHighlight, operationConverterText.syntaxHighlight) && Objects.equals(this.textHighlight, operationConverterText.textHighlight) && Objects.equals(this.useSyntaxDetection, operationConverterText.useSyntaxDetection);
    }

    public int hashCode() {
        return Objects.hash(this.syntaxHighlight, this.textHighlight, this.useSyntaxDetection);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterText {\n");
        sb.append("    syntaxHighlight: ").append(this.toIndentedString(this.syntaxHighlight)).append("\n");
        sb.append("    textHighlight: ").append(this.toIndentedString(this.textHighlight)).append("\n");
        sb.append("    useSyntaxDetection: ").append(this.toIndentedString(this.useSyntaxDetection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

