/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Can be used to enable expanded error reporting for text-based documents (e.g., Word).")
@JsonPropertyOrder(value={"contentProblems", "fontAliasUsage", "fontIsMissing"})
@JsonTypeName(value="Operation_ConverterReport")
public class OperationConverterReport {
    public static final String JSON_PROPERTY_CONTENT_PROBLEMS = "contentProblems";
    private Boolean contentProblems = false;
    public static final String JSON_PROPERTY_FONT_ALIAS_USAGE = "fontAliasUsage";
    private Boolean fontAliasUsage = false;
    public static final String JSON_PROPERTY_FONT_IS_MISSING = "fontIsMissing";
    private Boolean fontIsMissing = false;

    public OperationConverterReport contentProblems(Boolean contentProblems) {
        this.contentProblems = contentProblems;
        return this;
    }

    @Schema(name="If \"true\", then an error (ERR\\_CONVERTER\\_CONTENT\\_PROBLEMS) is triggered if a problem occurs with a content item during the conversion. The following are among the problems:  *   Unicode resolution of characters is not possible *   Vertical text elements *   Unsupported text effects *   Unsupported graphics compression *   Unsupported colour space *   Non-integrated sub-document that was not converted *   Tables with a \"right-to-left\" alignment in the content *   The document contains mathematical formulas")
    @JsonProperty(value="contentProblems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getContentProblems() {
        return this.contentProblems;
    }

    @JsonProperty(value="contentProblems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentProblems(Boolean contentProblems) {
        this.contentProblems = contentProblems;
    }

    public OperationConverterReport fontAliasUsage(Boolean fontAliasUsage) {
        this.fontAliasUsage = fontAliasUsage;
        return this;
    }

    @Schema(name="If \"true\", then an error (ERR\\_CONVERTER\\_FONT\\_ALIAS\\_USED) is triggered if a font was not found during conversion and in its place a substitute (alias) font was used.")
    @JsonProperty(value="fontAliasUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFontAliasUsage() {
        return this.fontAliasUsage;
    }

    @JsonProperty(value="fontAliasUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontAliasUsage(Boolean fontAliasUsage) {
        this.fontAliasUsage = fontAliasUsage;
    }

    public OperationConverterReport fontIsMissing(Boolean fontIsMissing) {
        this.fontIsMissing = fontIsMissing;
        return this;
    }

    @Schema(name="If \"true\", then an error (ERR\\_CONVERTER\\_FONT\\_IS\\_MISSING) is triggered if a font was not found during conversion.")
    @JsonProperty(value="fontIsMissing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFontIsMissing() {
        return this.fontIsMissing;
    }

    @JsonProperty(value="fontIsMissing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontIsMissing(Boolean fontIsMissing) {
        this.fontIsMissing = fontIsMissing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterReport operationConverterReport = (OperationConverterReport)o;
        return Objects.equals(this.contentProblems, operationConverterReport.contentProblems) && Objects.equals(this.fontAliasUsage, operationConverterReport.fontAliasUsage) && Objects.equals(this.fontIsMissing, operationConverterReport.fontIsMissing);
    }

    public int hashCode() {
        return Objects.hash(this.contentProblems, this.fontAliasUsage, this.fontIsMissing);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterReport {\n");
        sb.append("    contentProblems: ").append(this.toIndentedString(this.contentProblems)).append("\n");
        sb.append("    fontAliasUsage: ").append(this.toIndentedString(this.fontAliasUsage)).append("\n");
        sb.append("    fontIsMissing: ").append(this.toIndentedString(this.fontIsMissing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

