/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="This parameter specifies whether HTML content errors should be detected and, if so, whether a report should be provided along with the error code. The report is created only if at least one error was found. If the parameter is not specified, then any errors that may occur in the HTML document will not be detected and will be silently ignored.  **Important:** This parameter refers only to the content of the passed HTML document and not to the web service call itself.")
@JsonPropertyOrder(value={"format", "mode"})
@JsonTypeName(value="Operation_ConverterHtmlErrorReport")
public class OperationConverterHtmlErrorReport {
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format = FormatEnum.XML;
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.NONE;

    public OperationConverterHtmlErrorReport format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Schema(name="Defines the output format of the error report.  *   xml = XML document. *   json = JSON document")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public OperationConverterHtmlErrorReport mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="This parameter specifies whether HTML content errors should be detected and, if so, how to provide a report with the errors. A detected error can be a failed download of a resource (for example, an image) or a script or CSS syntax error.  *   none = No content errors are detected and no report is generated and returned. *   message = Content errors are detected and the report is returned as part of the error message")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterHtmlErrorReport operationConverterHtmlErrorReport = (OperationConverterHtmlErrorReport)o;
        return Objects.equals((Object)this.format, (Object)operationConverterHtmlErrorReport.format) && Objects.equals((Object)this.mode, (Object)operationConverterHtmlErrorReport.mode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.mode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterHtmlErrorReport {\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        NONE(String.valueOf("none")),
        MESSAGE(String.valueOf("message"));

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FormatEnum {
        XML(String.valueOf("xml")),
        JSON(String.valueOf("json"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

