/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationConverterHtmlErrorReport;
import net.webpdf.wsclient.openapi.OperationTemplateData;
import org.jetbrains.annotations.Nullable;

@Schema(description="These settings are only used for HTML (e.g. websites) and HTML-based documents (e.g. e-mails).")
@JsonPropertyOrder(value={"adjustFonts", "baseURL", "downloadImages", "errorReport", "imageMode", "preferCSSPageSize", "templateData", "useAsTemplate", "useBackground"})
@JsonTypeName(value="Operation_ConverterHtml")
public class OperationConverterHtml {
    public static final String JSON_PROPERTY_ADJUST_FONTS = "adjustFonts";
    private Boolean adjustFonts = false;
    public static final String JSON_PROPERTY_BASE_U_R_L = "baseURL";
    private String baseURL = "";
    public static final String JSON_PROPERTY_DOWNLOAD_IMAGES = "downloadImages";
    private Boolean downloadImages = false;
    public static final String JSON_PROPERTY_ERROR_REPORT = "errorReport";
    private OperationConverterHtmlErrorReport errorReport;
    public static final String JSON_PROPERTY_IMAGE_MODE = "imageMode";
    private ImageModeEnum imageMode = ImageModeEnum.BASE64;
    public static final String JSON_PROPERTY_PREFER_C_S_S_PAGE_SIZE = "preferCSSPageSize";
    private Boolean preferCSSPageSize = false;
    public static final String JSON_PROPERTY_TEMPLATE_DATA = "templateData";
    private OperationTemplateData templateData;
    public static final String JSON_PROPERTY_USE_AS_TEMPLATE = "useAsTemplate";
    private Boolean useAsTemplate = false;
    public static final String JSON_PROPERTY_USE_BACKGROUND = "useBackground";
    private Boolean useBackground = true;

    public OperationConverterHtml adjustFonts(Boolean adjustFonts) {
        this.adjustFonts = adjustFonts;
        return this;
    }

    @Schema(name="If \"true\", then the font specifications \"Arial\", \"Helvetica\" and \"Sans-Serif\" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \"Arial Unicode MS\" font. The improves the appearance of the typeface in the PDF result.")
    @JsonProperty(value="adjustFonts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAdjustFonts() {
        return this.adjustFonts;
    }

    @JsonProperty(value="adjustFonts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdjustFonts(Boolean adjustFonts) {
        this.adjustFonts = adjustFonts;
    }

    public OperationConverterHtml baseURL(String baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    @Schema(name="Used to define the URL that will be the base for all URLs in the HTML document that are not defined as absolute URLs. The URL must be absolute and contain a scheme (e.g. 'http' or 'https'); the scheme 'file' is not allowed.")
    @JsonProperty(value="baseURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getBaseURL() {
        return this.baseURL;
    }

    @JsonProperty(value="baseURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public OperationConverterHtml downloadImages(Boolean downloadImages) {
        this.downloadImages = downloadImages;
        return this;
    }

    @Schema(name="If \"true\", then externally referenced images of the HTML document are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact.")
    @JsonProperty(value="downloadImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDownloadImages() {
        return this.downloadImages;
    }

    @JsonProperty(value="downloadImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownloadImages(Boolean downloadImages) {
        this.downloadImages = downloadImages;
    }

    public OperationConverterHtml errorReport(OperationConverterHtmlErrorReport errorReport) {
        this.errorReport = errorReport;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationConverterHtmlErrorReport getErrorReport() {
        return this.errorReport;
    }

    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorReport(OperationConverterHtmlErrorReport errorReport) {
        this.errorReport = errorReport;
    }

    public OperationConverterHtml imageMode(ImageModeEnum imageMode) {
        this.imageMode = imageMode;
        return this;
    }

    @Schema(name="This defines how downloaded images are inserted into the HTML content (with reference to the `<downloadImages>` parameter). When referencing large images in the HTML content, it is recommended to use `<file>` to reduce the size of the HTML file and speed up the rendering of the HTML.  *   base64 = embed images as BASE64 content *   file = embed images as file links to local temporary files")
    @JsonProperty(value="imageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ImageModeEnum getImageMode() {
        return this.imageMode;
    }

    @JsonProperty(value="imageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageMode(ImageModeEnum imageMode) {
        this.imageMode = imageMode;
    }

    public OperationConverterHtml preferCSSPageSize(Boolean preferCSSPageSize) {
        this.preferCSSPageSize = preferCSSPageSize;
        return this;
    }

    @Schema(name="If \"true\", then the page size and margins are preferentially used from the CSS. Otherwise, the sizes from the passed page parameter are used. The values can also be only partially overwritten, so that e.g. the page size is determined by the parameter values and the page margins are defined in the CSS.")
    @JsonProperty(value="preferCSSPageSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPreferCSSPageSize() {
        return this.preferCSSPageSize;
    }

    @JsonProperty(value="preferCSSPageSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreferCSSPageSize(Boolean preferCSSPageSize) {
        this.preferCSSPageSize = preferCSSPageSize;
    }

    public OperationConverterHtml templateData(OperationTemplateData templateData) {
        this.templateData = templateData;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="templateData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationTemplateData getTemplateData() {
        return this.templateData;
    }

    @JsonProperty(value="templateData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplateData(OperationTemplateData templateData) {
        this.templateData = templateData;
    }

    public OperationConverterHtml useAsTemplate(Boolean useAsTemplate) {
        this.useAsTemplate = useAsTemplate;
        return this;
    }

    @Schema(name="If \"true\", the HTML document will be interpreted as a template, i.e., the system will search for variables in the HTML and replace them with the data passed in \"templateData\". The document will not be converted to HTML format until after this step is completed. This means that by using the HTML document as a template together with passed data, you can obtain a dynamically generated PDF document.")
    @JsonProperty(value="useAsTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseAsTemplate() {
        return this.useAsTemplate;
    }

    @JsonProperty(value="useAsTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseAsTemplate(Boolean useAsTemplate) {
        this.useAsTemplate = useAsTemplate;
    }

    public OperationConverterHtml useBackground(Boolean useBackground) {
        this.useBackground = useBackground;
        return this;
    }

    @Schema(name="If \"true\", the background defined in the HTML document will be output in the PDF document as well. If \"false\", the background will be hidden.")
    @JsonProperty(value="useBackground")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseBackground() {
        return this.useBackground;
    }

    @JsonProperty(value="useBackground")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseBackground(Boolean useBackground) {
        this.useBackground = useBackground;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterHtml operationConverterHtml = (OperationConverterHtml)o;
        return Objects.equals(this.adjustFonts, operationConverterHtml.adjustFonts) && Objects.equals(this.baseURL, operationConverterHtml.baseURL) && Objects.equals(this.downloadImages, operationConverterHtml.downloadImages) && Objects.equals(this.errorReport, operationConverterHtml.errorReport) && Objects.equals((Object)this.imageMode, (Object)operationConverterHtml.imageMode) && Objects.equals(this.preferCSSPageSize, operationConverterHtml.preferCSSPageSize) && Objects.equals(this.templateData, operationConverterHtml.templateData) && Objects.equals(this.useAsTemplate, operationConverterHtml.useAsTemplate) && Objects.equals(this.useBackground, operationConverterHtml.useBackground);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.adjustFonts, this.baseURL, this.downloadImages, this.errorReport, this.imageMode, this.preferCSSPageSize, this.templateData, this.useAsTemplate, this.useBackground});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterHtml {\n");
        sb.append("    adjustFonts: ").append(this.toIndentedString(this.adjustFonts)).append("\n");
        sb.append("    baseURL: ").append(this.toIndentedString(this.baseURL)).append("\n");
        sb.append("    downloadImages: ").append(this.toIndentedString(this.downloadImages)).append("\n");
        sb.append("    errorReport: ").append(this.toIndentedString(this.errorReport)).append("\n");
        sb.append("    imageMode: ").append(this.toIndentedString((Object)this.imageMode)).append("\n");
        sb.append("    preferCSSPageSize: ").append(this.toIndentedString(this.preferCSSPageSize)).append("\n");
        sb.append("    templateData: ").append(this.toIndentedString(this.templateData)).append("\n");
        sb.append("    useAsTemplate: ").append(this.toIndentedString(this.useAsTemplate)).append("\n");
        sb.append("    useBackground: ").append(this.toIndentedString(this.useBackground)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ImageModeEnum {
        BASE64(String.valueOf("base64")),
        FILE(String.valueOf("file"));

        private String value;

        private ImageModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ImageModeEnum fromValue(String value) {
            for (ImageModeEnum b : ImageModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

