/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPdfaErrorCorrection;
import net.webpdf.wsclient.openapi.OperationZugferd;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to convert a PDF document to PDF/A.")
@JsonPropertyOrder(value={"autoTagging", "errorCorrection", "errorReport", "imageQuality", "level", "successReport", "zugferd"})
@JsonTypeName(value="Operation_ConvertPdfa")
public class OperationConvertPdfa {
    public static final String JSON_PROPERTY_AUTO_TAGGING = "autoTagging";
    private Boolean autoTagging = false;
    public static final String JSON_PROPERTY_ERROR_CORRECTION = "errorCorrection";
    private OperationPdfaErrorCorrection errorCorrection;
    public static final String JSON_PROPERTY_ERROR_REPORT = "errorReport";
    private ErrorReportEnum errorReport = ErrorReportEnum.NONE;
    public static final String JSON_PROPERTY_IMAGE_QUALITY = "imageQuality";
    private Integer imageQuality = 75;
    public static final String JSON_PROPERTY_LEVEL = "level";
    private LevelEnum level = LevelEnum._3B;
    public static final String JSON_PROPERTY_SUCCESS_REPORT = "successReport";
    private SuccessReportEnum successReport = SuccessReportEnum.NONE;
    public static final String JSON_PROPERTY_ZUGFERD = "zugferd";
    private OperationZugferd zugferd;

    public OperationConvertPdfa autoTagging(Boolean autoTagging) {
        this.autoTagging = autoTagging;
        return this;
    }

    @Schema(name="In order to convert a document to conformity levels PDF/A 1a-3a, the entire document must have appropriate structure information (tags). If auto tagging is enabled, the corresponding structure information (in the form of page tags) will be generated automatically before the actual conversion.")
    @JsonProperty(value="autoTagging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAutoTagging() {
        return this.autoTagging;
    }

    @JsonProperty(value="autoTagging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoTagging(Boolean autoTagging) {
        this.autoTagging = autoTagging;
    }

    public OperationConvertPdfa errorCorrection(OperationPdfaErrorCorrection errorCorrection) {
        this.errorCorrection = errorCorrection;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="errorCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPdfaErrorCorrection getErrorCorrection() {
        return this.errorCorrection;
    }

    @JsonProperty(value="errorCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCorrection(OperationPdfaErrorCorrection errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    public OperationConvertPdfa errorReport(ErrorReportEnum errorReport) {
        this.errorReport = errorReport;
        return this;
    }

    @Schema(name="This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.  *   none = An XML report will not be returned *   message = The XML report will be returned as part of the error message *   file = The XML report will be saved in a file")
    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ErrorReportEnum getErrorReport() {
        return this.errorReport;
    }

    @JsonProperty(value="errorReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorReport(ErrorReportEnum errorReport) {
        this.errorReport = errorReport;
    }

    public OperationConvertPdfa imageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @Schema(name="The quality for images which must be transformed during the conversion because they use a compression which is not allowed (e.g. JPX is not allowed in PDF/A-1) is defined using this parameter. Values in a range from 1 to 100 are allowed whereby a higher value means better quality, but also larger PDF documents.")
    @JsonProperty(value="imageQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getImageQuality() {
        return this.imageQuality;
    }

    @JsonProperty(value="imageQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
    }

    public OperationConvertPdfa level(LevelEnum level) {
        this.level = level;
        return this;
    }

    @Schema(name="Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).")
    @JsonProperty(value="level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public LevelEnum getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    public OperationConvertPdfa successReport(SuccessReportEnum successReport) {
        this.successReport = successReport;
        return this;
    }

    @Schema(name="This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.  *   none = An XML report will not be returned *   linked = The XML report will be appended at the end of the PDF/A document. *   zip = The PDF/A document and the XML report will be packaged together in a ZIP archive.  **Tip:** The format of the document generated with \"errorReport\" and \"successReport\" is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.")
    @JsonProperty(value="successReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SuccessReportEnum getSuccessReport() {
        return this.successReport;
    }

    @JsonProperty(value="successReport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccessReport(SuccessReportEnum successReport) {
        this.successReport = successReport;
    }

    public OperationConvertPdfa zugferd(OperationZugferd zugferd) {
        this.zugferd = zugferd;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="zugferd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationZugferd getZugferd() {
        return this.zugferd;
    }

    @JsonProperty(value="zugferd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setZugferd(OperationZugferd zugferd) {
        this.zugferd = zugferd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConvertPdfa operationConvertPdfa = (OperationConvertPdfa)o;
        return Objects.equals(this.autoTagging, operationConvertPdfa.autoTagging) && Objects.equals(this.errorCorrection, operationConvertPdfa.errorCorrection) && Objects.equals((Object)this.errorReport, (Object)operationConvertPdfa.errorReport) && Objects.equals(this.imageQuality, operationConvertPdfa.imageQuality) && Objects.equals((Object)this.level, (Object)operationConvertPdfa.level) && Objects.equals((Object)this.successReport, (Object)operationConvertPdfa.successReport) && Objects.equals(this.zugferd, operationConvertPdfa.zugferd);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoTagging, this.errorCorrection, this.errorReport, this.imageQuality, this.level, this.successReport, this.zugferd});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConvertPdfa {\n");
        sb.append("    autoTagging: ").append(this.toIndentedString(this.autoTagging)).append("\n");
        sb.append("    errorCorrection: ").append(this.toIndentedString(this.errorCorrection)).append("\n");
        sb.append("    errorReport: ").append(this.toIndentedString((Object)this.errorReport)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString(this.imageQuality)).append("\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    successReport: ").append(this.toIndentedString((Object)this.successReport)).append("\n");
        sb.append("    zugferd: ").append(this.toIndentedString(this.zugferd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SuccessReportEnum {
        NONE(String.valueOf("none")),
        ZIP(String.valueOf("zip")),
        LINKED(String.valueOf("linked"));

        private String value;

        private SuccessReportEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SuccessReportEnum fromValue(String value) {
            for (SuccessReportEnum b : SuccessReportEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LevelEnum {
        _1A(String.valueOf("1a")),
        _1B(String.valueOf("1b")),
        _2A(String.valueOf("2a")),
        _2B(String.valueOf("2b")),
        _2U(String.valueOf("2u")),
        _3A(String.valueOf("3a")),
        _3B(String.valueOf("3b")),
        _3U(String.valueOf("3u"));

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LevelEnum fromValue(String value) {
            for (LevelEnum b : LevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ErrorReportEnum {
        NONE(String.valueOf("none")),
        FILE(String.valueOf("file")),
        MESSAGE(String.valueOf("message"));

        private String value;

        private ErrorReportEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ErrorReportEnum fromValue(String value) {
            for (ErrorReportEnum b : ErrorReportEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

