/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Combines object definitions of the document into so-called \"object streams\" and compresses them. This operation is recommended especially for larger documents with many objects. The size of contained resources (such as graphics and fonts) cannot be reduced in this way.")
@JsonPropertyOrder(value={"objectStreamSize"})
@JsonTypeName(value="Operation_CompressObjects")
public class OperationCompressObjects {
    public static final String JSON_PROPERTY_OBJECT_STREAM_SIZE = "objectStreamSize";
    private Integer objectStreamSize = 200;

    public OperationCompressObjects objectStreamSize(Integer objectStreamSize) {
        this.objectStreamSize = objectStreamSize;
        return this;
    }

    @Schema(name="Specifies the number of objects that may be combined into one stream. The higher the number, the higher the expected effect (assuming that the document contains a large number of objects). On the other hand, very large object streams can have a negative effect on the loading and display speed of the document in readers. For values beyond 500 objects, it is recommended to perform a manual check whether the document can still be displayed without problems.")
    @JsonProperty(value="objectStreamSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getObjectStreamSize() {
        return this.objectStreamSize;
    }

    @JsonProperty(value="objectStreamSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectStreamSize(Integer objectStreamSize) {
        this.objectStreamSize = objectStreamSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationCompressObjects operationCompressObjects = (OperationCompressObjects)o;
        return Objects.equals(this.objectStreamSize, operationCompressObjects.objectStreamSize);
    }

    public int hashCode() {
        return Objects.hash(this.objectStreamSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationCompressObjects {\n");
        sb.append("    objectStreamSize: ").append(this.toIndentedString(this.objectStreamSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

