/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a page transition for the full screen mode of the document.")
@JsonPropertyOrder(value={"autoScroll", "direction", "duration", "flyAreaOpaque", "flyScale", "objectKey", "page", "style"})
@JsonTypeName(value="Metadata_Transition")
public class MetadataTransition {
    public static final String JSON_PROPERTY_AUTO_SCROLL = "autoScroll";
    private Boolean autoScroll = false;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction = DirectionEnum.NONE;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Float duration = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_FLY_AREA_OPAQUE = "flyAreaOpaque";
    private Boolean flyAreaOpaque = false;
    public static final String JSON_PROPERTY_FLY_SCALE = "flyScale";
    private Float flyScale = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_STYLE = "style";
    private StyleEnum style = StyleEnum.NONE;

    public MetadataTransition autoScroll(Boolean autoScroll) {
        this.autoScroll = autoScroll;
        return this;
    }

    @Schema(name="Whether or not the page is automatically flipped after a short period.")
    @JsonProperty(value="autoScroll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAutoScroll() {
        return this.autoScroll;
    }

    @JsonProperty(value="autoScroll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoScroll(Boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public MetadataTransition direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Schema(name="The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight = From left to right *   bottomToTop = From bottom to top *   rightToLeft = From right to left *   topToBottom = From top to bottom *   topLeftToBottomRight = From top left to bottom right *   none = Use the default value for the animation")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public MetadataTransition duration(Float duration) {
        this.duration = duration;
        return this;
    }

    @Schema(name="Selects the duration in seconds, that the animation shall be played for.")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public MetadataTransition flyAreaOpaque(Boolean flyAreaOpaque) {
        this.flyAreaOpaque = flyAreaOpaque;
        return this;
    }

    @Schema(name="For a fly animation, this determines whether or not the opacity shall stay constantly opaque during the animation.")
    @JsonProperty(value="flyAreaOpaque")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFlyAreaOpaque() {
        return this.flyAreaOpaque;
    }

    @JsonProperty(value="flyAreaOpaque")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlyAreaOpaque(Boolean flyAreaOpaque) {
        this.flyAreaOpaque = flyAreaOpaque;
    }

    public MetadataTransition flyScale(Float flyScale) {
        this.flyScale = flyScale;
        return this;
    }

    @Schema(name="For a fly animation, this determines the initial scale of the page, when flying in.")
    @JsonProperty(value="flyScale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getFlyScale() {
        return this.flyScale;
    }

    @JsonProperty(value="flyScale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlyScale(Float flyScale) {
        this.flyScale = flyScale;
    }

    public MetadataTransition objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the transition definition. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataTransition page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The page a transition shall be defined for.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MetadataTransition style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @Schema(name="The style of transition animation.  *   blinds = Crossfades *   box = Crossfades in a rectangular pattern *   cover = Covers *   dissolve = Dissolves *   fade = Fades *   fly = Page flies in *   glitter = Page dissolves and is replaced *   push = Page is pushed out *   split = Splits page *   uncover = Uncovers page *   wipe = Wipes page *   none = No special effect")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public StyleEnum getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataTransition metadataTransition = (MetadataTransition)o;
        return Objects.equals(this.autoScroll, metadataTransition.autoScroll) && Objects.equals((Object)this.direction, (Object)metadataTransition.direction) && Objects.equals(this.duration, metadataTransition.duration) && Objects.equals(this.flyAreaOpaque, metadataTransition.flyAreaOpaque) && Objects.equals(this.flyScale, metadataTransition.flyScale) && Objects.equals(this.objectKey, metadataTransition.objectKey) && Objects.equals(this.page, metadataTransition.page) && Objects.equals((Object)this.style, (Object)metadataTransition.style);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoScroll, this.direction, this.duration, this.flyAreaOpaque, this.flyScale, this.objectKey, this.page, this.style});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataTransition {\n");
        sb.append("    autoScroll: ").append(this.toIndentedString(this.autoScroll)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    flyAreaOpaque: ").append(this.toIndentedString(this.flyAreaOpaque)).append("\n");
        sb.append("    flyScale: ").append(this.toIndentedString(this.flyScale)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StyleEnum {
        BLINDS(String.valueOf("blinds")),
        BOX(String.valueOf("box")),
        COVER(String.valueOf("cover")),
        DISSOLVE(String.valueOf("dissolve")),
        FADE(String.valueOf("fade")),
        FLY(String.valueOf("fly")),
        GLITTER(String.valueOf("glitter")),
        PUSH(String.valueOf("push")),
        SPLIT(String.valueOf("split")),
        UNCOVER(String.valueOf("uncover")),
        WIPE(String.valueOf("wipe")),
        NONE(String.valueOf("none"));

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DirectionEnum {
        LEFT_TO_RIGHT(String.valueOf("leftToRight")),
        BOTTOM_TO_TOP(String.valueOf("bottomToTop")),
        RIGHT_TO_LEFT(String.valueOf("rightToLeft")),
        TOP_TO_BOTTOM(String.valueOf("topToBottom")),
        TOP_LEFT_TO_BOTTOM_RIGHT(String.valueOf("topLeftToBottomRight")),
        NONE(String.valueOf("none"));

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

