/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="An element of this type represents the properties of a signature.")
@JsonPropertyOrder(value={"contact", "date", "filter", "location", "name", "objectKey", "reason", "subFilter"})
@JsonTypeName(value="Metadata_Signature")
public class MetadataSignature {
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private String contact = "";
    public static final String JSON_PROPERTY_DATE = "date";
    private String date = "";
    public static final String JSON_PROPERTY_FILTER = "filter";
    private String filter = "";
    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location = "";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason = "";
    public static final String JSON_PROPERTY_SUB_FILTER = "subFilter";
    private String subFilter = "";

    public MetadataSignature contact(String contact) {
        this.contact = contact;
        return this;
    }

    @Schema(name="The contact information provided by the signer.")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(String contact) {
        this.contact = contact;
    }

    public MetadataSignature date(String date) {
        this.date = date;
        return this;
    }

    @Schema(name="The date the signature has been created.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(String date) {
        this.date = date;
    }

    public MetadataSignature filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Schema(name="The name of the preferred signature handler used for validation. (Adobe.PPKLite, EntrustPPKEF etc.)")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public MetadataSignature location(String location) {
        this.location = location;
        return this;
    }

    @Schema(name="The location the document has been signed at.")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(String location) {
        this.location = location;
    }

    public MetadataSignature name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The name of the person or authority signing the document.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MetadataSignature objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the signature. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataSignature reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Schema(name="The reason for signing the document.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public MetadataSignature subFilter(String subFilter) {
        this.subFilter = subFilter;
        return this;
    }

    @Schema(name="The encoding of the signature value, that shall also be used for validation. (adbe.x509.rsa\\_sha1, adbe.pkcs7.sha1, etc.)")
    @JsonProperty(value="subFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubFilter() {
        return this.subFilter;
    }

    @JsonProperty(value="subFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubFilter(String subFilter) {
        this.subFilter = subFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSignature metadataSignature = (MetadataSignature)o;
        return Objects.equals(this.contact, metadataSignature.contact) && Objects.equals(this.date, metadataSignature.date) && Objects.equals(this.filter, metadataSignature.filter) && Objects.equals(this.location, metadataSignature.location) && Objects.equals(this.name, metadataSignature.name) && Objects.equals(this.objectKey, metadataSignature.objectKey) && Objects.equals(this.reason, metadataSignature.reason) && Objects.equals(this.subFilter, metadataSignature.subFilter);
    }

    public int hashCode() {
        return Objects.hash(this.contact, this.date, this.filter, this.location, this.name, this.objectKey, this.reason, this.subFilter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataSignature {\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    subFilter: ").append(this.toIndentedString(this.subFilter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

