/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Changes the reply state of the selected annotation.")
@JsonPropertyOrder(value={"objectID", "state"})
@JsonTypeName(value="Metadata_ReplyStateRelation")
public class MetadataReplyStateRelation {
    public static final String JSON_PROPERTY_OBJECT_I_D = "objectID";
    private String objectID = "";
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state = StateEnum.NONE;

    public MetadataReplyStateRelation objectID(String objectID) {
        this.objectID = objectID;
        return this;
    }

    @Schema(name="The object ID of the annotation. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectID() {
        return this.objectID;
    }

    @JsonProperty(value="objectID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public MetadataReplyStateRelation state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Schema(name="The set reply state of a commented annotation.  *   accepted = The user agrees with the change. *   rejected = The user disagrees with the change. *   cancelled = The change has been cancelled. *   completed = The change has been completed. *   none = The user did not set a state.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataReplyStateRelation metadataReplyStateRelation = (MetadataReplyStateRelation)o;
        return Objects.equals(this.objectID, metadataReplyStateRelation.objectID) && Objects.equals((Object)this.state, (Object)metadataReplyStateRelation.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectID, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataReplyStateRelation {\n");
        sb.append("    objectID: ").append(this.toIndentedString(this.objectID)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        ACCEPTED(String.valueOf("accepted")),
        REJECTED(String.valueOf("rejected")),
        CANCELLED(String.valueOf("cancelled")),
        COMPLETED(String.valueOf("completed")),
        NONE(String.valueOf("none"));

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

