/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The PDF/A standard the document claims to be conforming to.")
@JsonPropertyOrder(value={"conformance", "part"})
@JsonTypeName(value="Metadata_Pdfa")
public class MetadataPdfa {
    public static final String JSON_PROPERTY_CONFORMANCE = "conformance";
    private String conformance = "";
    public static final String JSON_PROPERTY_PART = "part";
    private String part = "";

    public MetadataPdfa conformance(String conformance) {
        this.conformance = conformance;
        return this;
    }

    @Schema(name="The PDF/A conformance level.")
    @JsonProperty(value="conformance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConformance() {
        return this.conformance;
    }

    @JsonProperty(value="conformance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConformance(String conformance) {
        this.conformance = conformance;
    }

    public MetadataPdfa part(String part) {
        this.part = part;
        return this;
    }

    @Schema(name="The ISO-19005 part number.")
    @JsonProperty(value="part")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPart() {
        return this.part;
    }

    @JsonProperty(value="part")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPart(String part) {
        this.part = part;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataPdfa metadataPdfa = (MetadataPdfa)o;
        return Objects.equals(this.conformance, metadataPdfa.conformance) && Objects.equals(this.part, metadataPdfa.part);
    }

    public int hashCode() {
        return Objects.hash(this.conformance, this.part);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataPdfa {\n");
        sb.append("    conformance: ").append(this.toIndentedString(this.conformance)).append("\n");
        sb.append("    part: ").append(this.toIndentedString(this.part)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

