/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a set of attributes for Line annotations.")
@JsonPropertyOrder(value={"captionHorizontalOffset", "captionPositioning", "captionVerticalOffset", "endStyle", "leaderLineExtensionLength", "leaderLineLength", "leaderLineOffsetLength", "showCaption", "startStyle"})
@JsonTypeName(value="Metadata_Line")
public class MetadataLine {
    public static final String JSON_PROPERTY_CAPTION_HORIZONTAL_OFFSET = "captionHorizontalOffset";
    private Float captionHorizontalOffset = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_CAPTION_POSITIONING = "captionPositioning";
    private String captionPositioning = "";
    public static final String JSON_PROPERTY_CAPTION_VERTICAL_OFFSET = "captionVerticalOffset";
    private Float captionVerticalOffset = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_END_STYLE = "endStyle";
    private String endStyle = "";
    public static final String JSON_PROPERTY_LEADER_LINE_EXTENSION_LENGTH = "leaderLineExtensionLength";
    private Float leaderLineExtensionLength = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_LEADER_LINE_LENGTH = "leaderLineLength";
    private Float leaderLineLength = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_LEADER_LINE_OFFSET_LENGTH = "leaderLineOffsetLength";
    private Float leaderLineOffsetLength = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_SHOW_CAPTION = "showCaption";
    private Boolean showCaption = false;
    public static final String JSON_PROPERTY_START_STYLE = "startStyle";
    private String startStyle = "";

    public MetadataLine captionHorizontalOffset(Float captionHorizontalOffset) {
        this.captionHorizontalOffset = captionHorizontalOffset;
        return this;
    }

    @Schema(name="The horizontal offset of the caption's leading letter in relation to it's normal position.")
    @JsonProperty(value="captionHorizontalOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getCaptionHorizontalOffset() {
        return this.captionHorizontalOffset;
    }

    @JsonProperty(value="captionHorizontalOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptionHorizontalOffset(Float captionHorizontalOffset) {
        this.captionHorizontalOffset = captionHorizontalOffset;
    }

    public MetadataLine captionPositioning(String captionPositioning) {
        this.captionPositioning = captionPositioning;
        return this;
    }

    @Schema(name="The positioning method for the caption of the line. Possible values are \"Inline\" (superimposed) and \"Top\" (above the line).")
    @JsonProperty(value="captionPositioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCaptionPositioning() {
        return this.captionPositioning;
    }

    @JsonProperty(value="captionPositioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptionPositioning(String captionPositioning) {
        this.captionPositioning = captionPositioning;
    }

    public MetadataLine captionVerticalOffset(Float captionVerticalOffset) {
        this.captionVerticalOffset = captionVerticalOffset;
        return this;
    }

    @Schema(name="The vertical offset of the caption's leading letter in relation to it's normal position.")
    @JsonProperty(value="captionVerticalOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getCaptionVerticalOffset() {
        return this.captionVerticalOffset;
    }

    @JsonProperty(value="captionVerticalOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptionVerticalOffset(Float captionVerticalOffset) {
        this.captionVerticalOffset = captionVerticalOffset;
    }

    public MetadataLine endStyle(String endStyle) {
        this.endStyle = endStyle;
        return this;
    }

    @Schema(name="Selects the Line ending style at the end of the line. Possible values are: Square, Circle, Diamond, OpenArrow, ClosedArrow, None, Butt, ROpenArrow, RClosedArrow, Slash")
    @JsonProperty(value="endStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getEndStyle() {
        return this.endStyle;
    }

    @JsonProperty(value="endStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndStyle(String endStyle) {
        this.endStyle = endStyle;
    }

    public MetadataLine leaderLineExtensionLength(Float leaderLineExtensionLength) {
        this.leaderLineExtensionLength = leaderLineExtensionLength;
        return this;
    }

    @Schema(name="A non-negative number that shall represent the length of leader line extensions that extend from the line proper 180 degrees from the leader lines. (0 = no leader line extensions)")
    @JsonProperty(value="leaderLineExtensionLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getLeaderLineExtensionLength() {
        return this.leaderLineExtensionLength;
    }

    @JsonProperty(value="leaderLineExtensionLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLeaderLineExtensionLength(Float leaderLineExtensionLength) {
        this.leaderLineExtensionLength = leaderLineExtensionLength;
    }

    public MetadataLine leaderLineLength(Float leaderLineLength) {
        this.leaderLineLength = leaderLineLength;
        return this;
    }

    @Schema(name="The length of leader lines that extend from each endpoint of the line perpendicular to the line itself. A positive value shall mean that the leader lines appear in the direction that is clockwise when traversing the line from its starting point to its ending point; a negative value shall indicate the opposite direction.(0 = no leader lines)")
    @JsonProperty(value="leaderLineLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getLeaderLineLength() {
        return this.leaderLineLength;
    }

    @JsonProperty(value="leaderLineLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLeaderLineLength(Float leaderLineLength) {
        this.leaderLineLength = leaderLineLength;
    }

    public MetadataLine leaderLineOffsetLength(Float leaderLineOffsetLength) {
        this.leaderLineOffsetLength = leaderLineOffsetLength;
        return this;
    }

    @Schema(name="A non-negative number that shall represent the length of the leader line offset, which is the amount of empty space between the endpoints of the annotation and the beginning of the leader lines.")
    @JsonProperty(value="leaderLineOffsetLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getLeaderLineOffsetLength() {
        return this.leaderLineOffsetLength;
    }

    @JsonProperty(value="leaderLineOffsetLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLeaderLineOffsetLength(Float leaderLineOffsetLength) {
        this.leaderLineOffsetLength = leaderLineOffsetLength;
    }

    public MetadataLine showCaption(Boolean showCaption) {
        this.showCaption = showCaption;
        return this;
    }

    @Schema(name="When set to true the line shall display a textual caption.")
    @JsonProperty(value="showCaption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowCaption() {
        return this.showCaption;
    }

    @JsonProperty(value="showCaption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowCaption(Boolean showCaption) {
        this.showCaption = showCaption;
    }

    public MetadataLine startStyle(String startStyle) {
        this.startStyle = startStyle;
        return this;
    }

    @Schema(name="Selects the Line ending style at the start of the line.")
    @JsonProperty(value="startStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getStartStyle() {
        return this.startStyle;
    }

    @JsonProperty(value="startStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartStyle(String startStyle) {
        this.startStyle = startStyle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataLine metadataLine = (MetadataLine)o;
        return Objects.equals(this.captionHorizontalOffset, metadataLine.captionHorizontalOffset) && Objects.equals(this.captionPositioning, metadataLine.captionPositioning) && Objects.equals(this.captionVerticalOffset, metadataLine.captionVerticalOffset) && Objects.equals(this.endStyle, metadataLine.endStyle) && Objects.equals(this.leaderLineExtensionLength, metadataLine.leaderLineExtensionLength) && Objects.equals(this.leaderLineLength, metadataLine.leaderLineLength) && Objects.equals(this.leaderLineOffsetLength, metadataLine.leaderLineOffsetLength) && Objects.equals(this.showCaption, metadataLine.showCaption) && Objects.equals(this.startStyle, metadataLine.startStyle);
    }

    public int hashCode() {
        return Objects.hash(this.captionHorizontalOffset, this.captionPositioning, this.captionVerticalOffset, this.endStyle, this.leaderLineExtensionLength, this.leaderLineLength, this.leaderLineOffsetLength, this.showCaption, this.startStyle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataLine {\n");
        sb.append("    captionHorizontalOffset: ").append(this.toIndentedString(this.captionHorizontalOffset)).append("\n");
        sb.append("    captionPositioning: ").append(this.toIndentedString(this.captionPositioning)).append("\n");
        sb.append("    captionVerticalOffset: ").append(this.toIndentedString(this.captionVerticalOffset)).append("\n");
        sb.append("    endStyle: ").append(this.toIndentedString(this.endStyle)).append("\n");
        sb.append("    leaderLineExtensionLength: ").append(this.toIndentedString(this.leaderLineExtensionLength)).append("\n");
        sb.append("    leaderLineLength: ").append(this.toIndentedString(this.leaderLineLength)).append("\n");
        sb.append("    leaderLineOffsetLength: ").append(this.toIndentedString(this.leaderLineOffsetLength)).append("\n");
        sb.append("    showCaption: ").append(this.toIndentedString(this.showCaption)).append("\n");
        sb.append("    startStyle: ").append(this.toIndentedString(this.startStyle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

