/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines an image resource of a PDF document.")
@JsonPropertyOrder(value={"bitsPerComponent", "height", "objectKey", "page", "suffix", "width"})
@JsonTypeName(value="Metadata_Image")
public class MetadataImage {
    public static final String JSON_PROPERTY_BITS_PER_COMPONENT = "bitsPerComponent";
    private Integer bitsPerComponent = 0;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 0;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_SUFFIX = "suffix";
    private String suffix = "";
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 0;

    public MetadataImage bitsPerComponent(Integer bitsPerComponent) {
        this.bitsPerComponent = bitsPerComponent;
        return this;
    }

    @Schema(name="The number of bits used to encode one color component.")
    @JsonProperty(value="bitsPerComponent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    @JsonProperty(value="bitsPerComponent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBitsPerComponent(Integer bitsPerComponent) {
        this.bitsPerComponent = bitsPerComponent;
    }

    public MetadataImage height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(name="The height of the image in points.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public MetadataImage objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the image resource definition. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataImage page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The number of the page containing the image resource.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MetadataImage suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Schema(name="Returns the file type suffix of the image. (This suffix depends on the used image encoding and therefore is highly reliable.)")
    @JsonProperty(value="suffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    @JsonProperty(value="suffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public MetadataImage width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(name="The width of the image in points.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataImage metadataImage = (MetadataImage)o;
        return Objects.equals(this.bitsPerComponent, metadataImage.bitsPerComponent) && Objects.equals(this.height, metadataImage.height) && Objects.equals(this.objectKey, metadataImage.objectKey) && Objects.equals(this.page, metadataImage.page) && Objects.equals(this.suffix, metadataImage.suffix) && Objects.equals(this.width, metadataImage.width);
    }

    public int hashCode() {
        return Objects.hash(this.bitsPerComponent, this.height, this.objectKey, this.page, this.suffix, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataImage {\n");
        sb.append("    bitsPerComponent: ").append(this.toIndentedString(this.bitsPerComponent)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    suffix: ").append(this.toIndentedString(this.suffix)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

