/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataField;
import org.jetbrains.annotations.Nullable;

@Schema(description="Describes the properties of the document's form. (Should the document contain a form.)")
@JsonPropertyOrder(value={"defaultAppearance", "field", "formType", "needAppearances", "objectKey"})
@JsonTypeName(value="Metadata_FormDocument")
public class MetadataFormDocument {
    public static final String JSON_PROPERTY_DEFAULT_APPEARANCE = "defaultAppearance";
    private String defaultAppearance = "";
    public static final String JSON_PROPERTY_FIELD = "field";
    private List<MetadataField> field = null;
    public static final String JSON_PROPERTY_FORM_TYPE = "formType";
    private FormTypeEnum formType = FormTypeEnum.NONE;
    public static final String JSON_PROPERTY_NEED_APPEARANCES = "needAppearances";
    private Boolean needAppearances = false;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";

    public MetadataFormDocument defaultAppearance(String defaultAppearance) {
        this.defaultAppearance = defaultAppearance;
        return this;
    }

    @Schema(name="If present, this contains the default appearance of the form's fields. This shall be a string containing graphics and text state operators for example defining text colors, sizes etc.")
    @JsonProperty(value="defaultAppearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDefaultAppearance() {
        return this.defaultAppearance;
    }

    @JsonProperty(value="defaultAppearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultAppearance(String defaultAppearance) {
        this.defaultAppearance = defaultAppearance;
    }

    public MetadataFormDocument field(List<MetadataField> field) {
        this.field = field;
        return this;
    }

    public MetadataFormDocument addFieldItem(MetadataField fieldItem) {
        if (this.field == null) {
            this.field = new ArrayList<MetadataField>();
        }
        this.field.add(fieldItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataField> getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setField(List<MetadataField> field) {
        this.field = field;
    }

    public MetadataFormDocument formType(FormTypeEnum formType) {
        this.formType = formType;
        return this;
    }

    @Schema(name="When set to another value than \"none\", the document does contain a PDF form in the hereby given format.  *   none = The document does not contain a form. *   acroForm = The document contains a standard PDF Acroform. *   staticXFA = The document contains a \"XML Forms Architecture\" form with a fixed layout (static). *   dynamicXFA = The document contains a \"XML Forms Architecture\" form with an adaptable/interactive layout (dynamic).")
    @JsonProperty(value="formType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormTypeEnum getFormType() {
        return this.formType;
    }

    @JsonProperty(value="formType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormType(FormTypeEnum formType) {
        this.formType = formType;
    }

    public MetadataFormDocument needAppearances(Boolean needAppearances) {
        this.needAppearances = needAppearances;
        return this;
    }

    @Schema(name="When set to \"true\" the displaying Application shall generate appearances for all widgets defining the document's form.")
    @JsonProperty(value="needAppearances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getNeedAppearances() {
        return this.needAppearances;
    }

    @JsonProperty(value="needAppearances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNeedAppearances(Boolean needAppearances) {
        this.needAppearances = needAppearances;
    }

    public MetadataFormDocument objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the form.  **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFormDocument metadataFormDocument = (MetadataFormDocument)o;
        return Objects.equals(this.defaultAppearance, metadataFormDocument.defaultAppearance) && Objects.equals(this.field, metadataFormDocument.field) && Objects.equals((Object)this.formType, (Object)metadataFormDocument.formType) && Objects.equals(this.needAppearances, metadataFormDocument.needAppearances) && Objects.equals(this.objectKey, metadataFormDocument.objectKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultAppearance, this.field, this.formType, this.needAppearances, this.objectKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataFormDocument {\n");
        sb.append("    defaultAppearance: ").append(this.toIndentedString(this.defaultAppearance)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    formType: ").append(this.toIndentedString((Object)this.formType)).append("\n");
        sb.append("    needAppearances: ").append(this.toIndentedString(this.needAppearances)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormTypeEnum {
        NONE(String.valueOf("none")),
        ACRO_FORM(String.valueOf("acroForm")),
        STATIC_XFA(String.valueOf("staticXFA")),
        DYNAMIC_XFA(String.valueOf("dynamicXFA"));

        private String value;

        private FormTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormTypeEnum fromValue(String value) {
            for (FormTypeEnum b : FormTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

