/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataAuthor;
import net.webpdf.wsclient.openapi.MetadataCustomDescription;
import net.webpdf.wsclient.openapi.MetadataKeyword;
import org.jetbrains.annotations.Nullable;

@Schema(description="The document's description contains a number of metadata attributes, that further describe the author, creation, contents etc of the document.")
@JsonPropertyOrder(value={"application", "author", "creationDate", "creator", "custom", "keywords", "modificationDate", "producer", "subject", "title"})
@JsonTypeName(value="Metadata_Description")
public class MetadataDescription {
    public static final String JSON_PROPERTY_APPLICATION = "application";
    private String application = "";
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private List<MetadataAuthor> author = null;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private String creationDate = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    private List<MetadataCustomDescription> custom = null;
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private List<MetadataKeyword> keywords = null;
    public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
    private String modificationDate = "";
    public static final String JSON_PROPERTY_PRODUCER = "producer";
    private String producer = "";
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title = "";

    public MetadataDescription application(String application) {
        this.application = application;
        return this;
    }

    @Schema(name="The application used to create the document.")
    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getApplication() {
        return this.application;
    }

    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplication(String application) {
        this.application = application;
    }

    public MetadataDescription author(List<MetadataAuthor> author) {
        this.author = author;
        return this;
    }

    public MetadataDescription addAuthorItem(MetadataAuthor authorItem) {
        if (this.author == null) {
            this.author = new ArrayList<MetadataAuthor>();
        }
        this.author.add(authorItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataAuthor> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthor(List<MetadataAuthor> author) {
        this.author = author;
    }

    public MetadataDescription creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Schema(name="The date of the document's creation.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public MetadataDescription creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="If the document has been converted to a PDF from another format, this is the name of the application, that created the original document.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public MetadataDescription custom(List<MetadataCustomDescription> custom) {
        this.custom = custom;
        return this;
    }

    public MetadataDescription addCustomItem(MetadataCustomDescription customItem) {
        if (this.custom == null) {
            this.custom = new ArrayList<MetadataCustomDescription>();
        }
        this.custom.add(customItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataCustomDescription> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustom(List<MetadataCustomDescription> custom) {
        this.custom = custom;
    }

    public MetadataDescription keywords(List<MetadataKeyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    public MetadataDescription addKeywordsItem(MetadataKeyword keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<MetadataKeyword>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataKeyword> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeywords(List<MetadataKeyword> keywords) {
        this.keywords = keywords;
    }

    public MetadataDescription modificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    @Schema(name="The date of the most recent modification of the document.")
    @JsonProperty(value="modificationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getModificationDate() {
        return this.modificationDate;
    }

    @JsonProperty(value="modificationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
    }

    public MetadataDescription producer(String producer) {
        this.producer = producer;
        return this;
    }

    @Schema(name="If the document has been converted to a PDF from another format, this is the name of the application, that converted it.")
    @JsonProperty(value="producer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getProducer() {
        return this.producer;
    }

    @JsonProperty(value="producer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProducer(String producer) {
        this.producer = producer;
    }

    public MetadataDescription subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="The document's subject.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MetadataDescription title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="The document's title.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataDescription metadataDescription = (MetadataDescription)o;
        return Objects.equals(this.application, metadataDescription.application) && Objects.equals(this.author, metadataDescription.author) && Objects.equals(this.creationDate, metadataDescription.creationDate) && Objects.equals(this.creator, metadataDescription.creator) && Objects.equals(this.custom, metadataDescription.custom) && Objects.equals(this.keywords, metadataDescription.keywords) && Objects.equals(this.modificationDate, metadataDescription.modificationDate) && Objects.equals(this.producer, metadataDescription.producer) && Objects.equals(this.subject, metadataDescription.subject) && Objects.equals(this.title, metadataDescription.title);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.author, this.creationDate, this.creator, this.custom, this.keywords, this.modificationDate, this.producer, this.subject, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataDescription {\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    modificationDate: ").append(this.toIndentedString(this.modificationDate)).append("\n");
        sb.append("    producer: ").append(this.toIndentedString(this.producer)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

