/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentRecipient;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains password information if it is a PDF document")
@JsonPropertyOrder(value={"isCertificateSet", "isOpenSet", "isPermissionSet", "recipients"})
@JsonTypeName(value="Document_Password")
public class DocumentPassword {
    public static final String JSON_PROPERTY_IS_CERTIFICATE_SET = "isCertificateSet";
    private Boolean isCertificateSet = false;
    public static final String JSON_PROPERTY_IS_OPEN_SET = "isOpenSet";
    private Boolean isOpenSet = false;
    public static final String JSON_PROPERTY_IS_PERMISSION_SET = "isPermissionSet";
    private Boolean isPermissionSet = false;
    public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
    private List<DocumentRecipient> recipients = null;

    public DocumentPassword() {
    }

    @JsonCreator
    public DocumentPassword(@JsonProperty(value="isCertificateSet") Boolean isCertificateSet, @JsonProperty(value="isOpenSet") Boolean isOpenSet, @JsonProperty(value="isPermissionSet") Boolean isPermissionSet, @JsonProperty(value="recipients") List<DocumentRecipient> recipients) {
        this();
        this.isCertificateSet = isCertificateSet;
        this.isOpenSet = isOpenSet;
        this.isPermissionSet = isPermissionSet;
        this.recipients = recipients;
    }

    @Schema(name="True, if an certificate is set")
    @JsonProperty(value="isCertificateSet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsCertificateSet() {
        return this.isCertificateSet;
    }

    @Schema(name="True, if an open password is set")
    @JsonProperty(value="isOpenSet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsOpenSet() {
        return this.isOpenSet;
    }

    @Schema(name="True, if an permission password is set")
    @JsonProperty(value="isPermissionSet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsPermissionSet() {
        return this.isPermissionSet;
    }

    @Schema(name="List of recipients which are allowed to open the document")
    @JsonProperty(value="recipients")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<DocumentRecipient> getRecipients() {
        return this.recipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPassword documentPassword = (DocumentPassword)o;
        return Objects.equals(this.isCertificateSet, documentPassword.isCertificateSet) && Objects.equals(this.isOpenSet, documentPassword.isOpenSet) && Objects.equals(this.isPermissionSet, documentPassword.isPermissionSet) && Objects.equals(this.recipients, documentPassword.recipients);
    }

    public int hashCode() {
        return Objects.hash(this.isCertificateSet, this.isOpenSet, this.isPermissionSet, this.recipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentPassword {\n");
        sb.append("    isCertificateSet: ").append(this.toIndentedString(this.isCertificateSet)).append("\n");
        sb.append("    isOpenSet: ").append(this.toIndentedString(this.isOpenSet)).append("\n");
        sb.append("    isPermissionSet: ").append(this.toIndentedString(this.isPermissionSet)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

