/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a file entry in the file list of the metadata for an archive document.")
@JsonPropertyOrder(value={"lastModifiedDate", "path", "size"})
@JsonTypeName(value="Document_MetadataArchiveEntry")
public class DocumentMetadataArchiveEntry {
    public static final String JSON_PROPERTY_LAST_MODIFIED_DATE = "lastModifiedDate";
    private Long lastModifiedDate = 0L;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path = "";
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size = 0L;

    public DocumentMetadataArchiveEntry() {
    }

    @JsonCreator
    public DocumentMetadataArchiveEntry(@JsonProperty(value="lastModifiedDate") Long lastModifiedDate, @JsonProperty(value="path") String path, @JsonProperty(value="size") Long size) {
        this();
        this.lastModifiedDate = lastModifiedDate;
        this.path = path;
        this.size = size;
    }

    @Schema(name="Time at which the file was last changed")
    @JsonProperty(value="lastModifiedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @Schema(name="File name and path within the archive")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Schema(name="File size in bytes")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMetadataArchiveEntry documentMetadataArchiveEntry = (DocumentMetadataArchiveEntry)o;
        return Objects.equals(this.lastModifiedDate, documentMetadataArchiveEntry.lastModifiedDate) && Objects.equals(this.path, documentMetadataArchiveEntry.path) && Objects.equals(this.size, documentMetadataArchiveEntry.size);
    }

    public int hashCode() {
        return Objects.hash(this.lastModifiedDate, this.path, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentMetadataArchiveEntry {\n");
        sb.append("    lastModifiedDate: ").append(this.toIndentedString(this.lastModifiedDate)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

