/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentFileFilter;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains the instructions for creating the new archive document and the documents to be added to the archive.")
@JsonPropertyOrder(value={"archiveFileName", "documentIdList", "fileFilter", "storeArchive"})
@JsonTypeName(value="Document_FileCompress")
public class DocumentFileCompress {
    public static final String JSON_PROPERTY_ARCHIVE_FILE_NAME = "archiveFileName";
    private String archiveFileName = "archive.zip";
    public static final String JSON_PROPERTY_DOCUMENT_ID_LIST = "documentIdList";
    private List<String> documentIdList = null;
    public static final String JSON_PROPERTY_FILE_FILTER = "fileFilter";
    private DocumentFileFilter fileFilter;
    public static final String JSON_PROPERTY_STORE_ARCHIVE = "storeArchive";
    private Boolean storeArchive = false;

    public DocumentFileCompress archiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
        return this;
    }

    @Schema(name="Sets the file name for the archive document.")
    @JsonProperty(value="archiveFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    @JsonProperty(value="archiveFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
    }

    public DocumentFileCompress documentIdList(List<String> documentIdList) {
        this.documentIdList = documentIdList;
        return this;
    }

    public DocumentFileCompress addDocumentIdListItem(String documentIdListItem) {
        if (this.documentIdList == null) {
            this.documentIdList = new ArrayList<String>();
        }
        this.documentIdList.add(documentIdListItem);
        return this;
    }

    @Schema(name="Sets the list of `documentId`s to be added to the archive document.")
    @JsonProperty(value="documentIdList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getDocumentIdList() {
        return this.documentIdList;
    }

    @JsonProperty(value="documentIdList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentIdList(List<String> documentIdList) {
        this.documentIdList = documentIdList;
    }

    public DocumentFileCompress fileFilter(DocumentFileFilter fileFilter) {
        this.fileFilter = fileFilter;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="fileFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocumentFileFilter getFileFilter() {
        return this.fileFilter;
    }

    @JsonProperty(value="fileFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileFilter(DocumentFileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public DocumentFileCompress storeArchive(Boolean storeArchive) {
        this.storeArchive = storeArchive;
        return this;
    }

    @Schema(name="Defines whether the archive is saved in the document storage or only created temporarily.")
    @JsonProperty(value="storeArchive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getStoreArchive() {
        return this.storeArchive;
    }

    @JsonProperty(value="storeArchive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreArchive(Boolean storeArchive) {
        this.storeArchive = storeArchive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFileCompress documentFileCompress = (DocumentFileCompress)o;
        return Objects.equals(this.archiveFileName, documentFileCompress.archiveFileName) && Objects.equals(this.documentIdList, documentFileCompress.documentIdList) && Objects.equals(this.fileFilter, documentFileCompress.fileFilter) && Objects.equals(this.storeArchive, documentFileCompress.storeArchive);
    }

    public int hashCode() {
        return Objects.hash(this.archiveFileName, this.documentIdList, this.fileFilter, this.storeArchive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentFileCompress {\n");
        sb.append("    archiveFileName: ").append(this.toIndentedString(this.archiveFileName)).append("\n");
        sb.append("    documentIdList: ").append(this.toIndentedString(this.documentIdList)).append("\n");
        sb.append("    fileFilter: ").append(this.toIndentedString(this.fileFilter)).append("\n");
        sb.append("    storeArchive: ").append(this.toIndentedString(this.storeArchive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

