/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.KeyStoreOrigin;
import org.jetbrains.annotations.Nullable;

@Schema(description="An actual X509 certificate entry.")
@JsonPropertyOrder(value={"aliasName", "certificate", "hasPrivateKey", "isPrivateKeyReadable", "keyStoreName", "keyStoreOrigin"})
@JsonTypeName(value="Certificate_Entry")
public class CertificateEntry {
    public static final String JSON_PROPERTY_ALIAS_NAME = "aliasName";
    private String aliasName = "";
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private String certificate = "";
    public static final String JSON_PROPERTY_HAS_PRIVATE_KEY = "hasPrivateKey";
    private Boolean hasPrivateKey = false;
    public static final String JSON_PROPERTY_IS_PRIVATE_KEY_READABLE = "isPrivateKeyReadable";
    private Boolean isPrivateKeyReadable = false;
    public static final String JSON_PROPERTY_KEY_STORE_NAME = "keyStoreName";
    private String keyStoreName = "";
    public static final String JSON_PROPERTY_KEY_STORE_ORIGIN = "keyStoreOrigin";
    private KeyStoreOrigin keyStoreOrigin = KeyStoreOrigin.GLOBAL;

    public CertificateEntry() {
    }

    @JsonCreator
    public CertificateEntry(@JsonProperty(value="aliasName") String aliasName, @JsonProperty(value="certificate") String certificate, @JsonProperty(value="hasPrivateKey") Boolean hasPrivateKey, @JsonProperty(value="isPrivateKeyReadable") Boolean isPrivateKeyReadable, @JsonProperty(value="keyStoreName") String keyStoreName) {
        this();
        this.aliasName = aliasName;
        this.certificate = certificate;
        this.hasPrivateKey = hasPrivateKey;
        this.isPrivateKeyReadable = isPrivateKeyReadable;
        this.keyStoreName = keyStoreName;
    }

    @Schema(name="Alias name for the certificate")
    @JsonProperty(value="aliasName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAliasName() {
        return this.aliasName;
    }

    @Schema(name="PEM encoded certificate")
    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCertificate() {
        return this.certificate;
    }

    @Schema(name="true = private key is available for the certificate")
    @JsonProperty(value="hasPrivateKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHasPrivateKey() {
        return this.hasPrivateKey;
    }

    @Schema(name="true = private key is available and readable")
    @JsonProperty(value="isPrivateKeyReadable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsPrivateKeyReadable() {
        return this.isPrivateKeyReadable;
    }

    @Schema(name="Name of the keystore from which the certificate was originally obtained.")
    @JsonProperty(value="keyStoreName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public CertificateEntry keyStoreOrigin(KeyStoreOrigin keyStoreOrigin) {
        this.keyStoreOrigin = keyStoreOrigin;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="keyStoreOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public KeyStoreOrigin getKeyStoreOrigin() {
        return this.keyStoreOrigin;
    }

    @JsonProperty(value="keyStoreOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyStoreOrigin(KeyStoreOrigin keyStoreOrigin) {
        this.keyStoreOrigin = keyStoreOrigin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateEntry certificateEntry = (CertificateEntry)o;
        return Objects.equals(this.aliasName, certificateEntry.aliasName) && Objects.equals(this.certificate, certificateEntry.certificate) && Objects.equals(this.hasPrivateKey, certificateEntry.hasPrivateKey) && Objects.equals(this.isPrivateKeyReadable, certificateEntry.isPrivateKeyReadable) && Objects.equals(this.keyStoreName, certificateEntry.keyStoreName) && Objects.equals((Object)this.keyStoreOrigin, (Object)certificateEntry.keyStoreOrigin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aliasName, this.certificate, this.hasPrivateKey, this.isPrivateKeyReadable, this.keyStoreName, this.keyStoreOrigin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CertificateEntry {\n");
        sb.append("    aliasName: ").append(this.toIndentedString(this.aliasName)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    hasPrivateKey: ").append(this.toIndentedString(this.hasPrivateKey)).append("\n");
        sb.append("    isPrivateKeyReadable: ").append(this.toIndentedString(this.isPrivateKeyReadable)).append("\n");
        sb.append("    keyStoreName: ").append(this.toIndentedString(this.keyStoreName)).append("\n");
        sb.append("    keyStoreOrigin: ").append(this.toIndentedString((Object)this.keyStoreOrigin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

