/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AuthLimits;
import org.jetbrains.annotations.NotNull;

@Schema(description="Returns details about a user in a session")
@JsonPropertyOrder(value={"isAdmin", "isUser", "roles", "uniqueId", "userLimits", "userName"})
@JsonTypeName(value="Auth_UserCredentials")
public class AuthUserCredentials {
    public static final String JSON_PROPERTY_IS_ADMIN = "isAdmin";
    private Boolean isAdmin = false;
    public static final String JSON_PROPERTY_IS_USER = "isUser";
    private Boolean isUser = true;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_UNIQUE_ID = "uniqueId";
    private String uniqueId = "";
    public static final String JSON_PROPERTY_USER_LIMITS = "userLimits";
    private AuthLimits userLimits;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName = "";

    public AuthUserCredentials() {
    }

    @JsonCreator
    public AuthUserCredentials(@JsonProperty(value="isAdmin") Boolean isAdmin, @JsonProperty(value="isUser") Boolean isUser, @JsonProperty(value="roles") List<String> roles, @JsonProperty(value="uniqueId") String uniqueId, @JsonProperty(value="userName") String userName) {
        this();
        this.isAdmin = isAdmin;
        this.isUser = isUser;
        this.roles = roles;
        this.uniqueId = uniqueId;
        this.userName = userName;
    }

    @Schema(required=true, name="true = An administration user")
    @JsonProperty(value="isAdmin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    @Schema(required=true, name="true = A standard user")
    @JsonProperty(value="isUser")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public Boolean getIsUser() {
        return this.isUser;
    }

    @Schema(required=true, name="Roles assigned to the user")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<String> getRoles() {
        return this.roles;
    }

    @Schema(required=true, name="Unique ID for the user")
    @JsonProperty(value="uniqueId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getUniqueId() {
        return this.uniqueId;
    }

    public AuthUserCredentials userLimits(AuthLimits userLimits) {
        this.userLimits = userLimits;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="userLimits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public AuthLimits getUserLimits() {
        return this.userLimits;
    }

    @JsonProperty(value="userLimits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserLimits(AuthLimits userLimits) {
        this.userLimits = userLimits;
    }

    @Schema(required=true, name="Name of the user")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getUserName() {
        return this.userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthUserCredentials authUserCredentials = (AuthUserCredentials)o;
        return Objects.equals(this.isAdmin, authUserCredentials.isAdmin) && Objects.equals(this.isUser, authUserCredentials.isUser) && Objects.equals(this.roles, authUserCredentials.roles) && Objects.equals(this.uniqueId, authUserCredentials.uniqueId) && Objects.equals(this.userLimits, authUserCredentials.userLimits) && Objects.equals(this.userName, authUserCredentials.userName);
    }

    public int hashCode() {
        return Objects.hash(this.isAdmin, this.isUser, this.roles, this.uniqueId, this.userLimits, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthUserCredentials {\n");
        sb.append("    isAdmin: ").append(this.toIndentedString(this.isAdmin)).append("\n");
        sb.append("    isUser: ").append(this.toIndentedString(this.isUser)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    uniqueId: ").append(this.toIndentedString(this.uniqueId)).append("\n");
        sb.append("    userLimits: ").append(this.toIndentedString(this.userLimits)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

