/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Session token")
@JsonPropertyOrder(value={"expiresIn", "refreshToken", "token"})
@JsonTypeName(value="Auth_SessionToken")
public class AuthSessionToken {
    public static final String JSON_PROPERTY_EXPIRES_IN = "expiresIn";
    private Long expiresIn = 0L;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refreshToken";
    private String refreshToken = "";
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token = "";

    public AuthSessionToken() {
    }

    @JsonCreator
    public AuthSessionToken(@JsonProperty(value="expiresIn") Long expiresIn, @JsonProperty(value="refreshToken") String refreshToken, @JsonProperty(value="token") String token) {
        this();
        this.expiresIn = expiresIn;
        this.refreshToken = refreshToken;
        this.token = token;
    }

    @Schema(name="If the access token expires, the duration of time in seconds the access token is granted for.")
    @JsonProperty(value="expiresIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @Schema(name="The refresh token string as issued by the server. When the access token expires, this token can be used to request a new access token.")
    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Schema(required=true, name="The access token string as issued by the server.")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthSessionToken authSessionToken = (AuthSessionToken)o;
        return Objects.equals(this.expiresIn, authSessionToken.expiresIn) && Objects.equals(this.refreshToken, authSessionToken.refreshToken) && Objects.equals(this.token, authSessionToken.token);
    }

    public int hashCode() {
        return Objects.hash(this.expiresIn, this.refreshToken, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthSessionToken {\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

