/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a set of options specific for the \"URL Converter\" web service.")
@JsonPropertyOrder(value={"enabled", "instances", "maxLatency", "queueMode", "queueSize", "timeout", "userAgent"})
@JsonTypeName(value="ApplicationConfig_UrlConverterWebservice")
public class ApplicationConfigUrlConverterWebservice {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_INSTANCES = "instances";
    private Integer instances = 2;
    public static final String JSON_PROPERTY_MAX_LATENCY = "maxLatency";
    private Integer maxLatency = 180;
    public static final String JSON_PROPERTY_QUEUE_MODE = "queueMode";
    private QueueModeEnum queueMode = QueueModeEnum.AUTO;
    public static final String JSON_PROPERTY_QUEUE_SIZE = "queueSize";
    private Integer queueSize = 100;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private Integer timeout = 60000;
    public static final String JSON_PROPERTY_USER_AGENT = "userAgent";
    private String userAgent = "Mozilla/5.0 (Windows; U; Windows NT 6.1; de-DE) AppleWebKit/532.4 (KHTML, like Gecko) Qt/4.6.1 Safari/532.4";

    public ApplicationConfigUrlConverterWebservice enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If enabled, then the web service is activated.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationConfigUrlConverterWebservice instances(Integer instances) {
        this.instances = instances;
        return this;
    }

    @Schema(name="Number of parallel instances (threads) for the web service. Defines the number of requests that can be executed in parallel before requests are queued.")
    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstances(Integer instances) {
        this.instances = instances;
    }

    public ApplicationConfigUrlConverterWebservice maxLatency(Integer maxLatency) {
        this.maxLatency = maxLatency;
        return this;
    }

    @Schema(name="Maximum allowed time in seconds for the execution of a web service request (job) before the request is canceled. If the time has expired, the execution is aborted and an error code is returned.")
    @JsonProperty(value="maxLatency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxLatency() {
        return this.maxLatency;
    }

    @JsonProperty(value="maxLatency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLatency(Integer maxLatency) {
        this.maxLatency = maxLatency;
    }

    public ApplicationConfigUrlConverterWebservice queueMode(QueueModeEnum queueMode) {
        this.queueMode = queueMode;
        return this;
    }

    @Schema(name="Defines how the size of the queue is determined.  With `AUTO`, it is calculated automatically by the server based on the number of configured instances.")
    @JsonProperty(value="queueMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public QueueModeEnum getQueueMode() {
        return this.queueMode;
    }

    @JsonProperty(value="queueMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQueueMode(QueueModeEnum queueMode) {
        this.queueMode = queueMode;
    }

    public ApplicationConfigUrlConverterWebservice queueSize(Integer queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @Schema(name="Maximum number of waiting requests, before new requests are rejected. If there are more requests than free instances, they are placed in the queue. If this maximum value is reached, further requests are rejected directly. This setting only applies if `queueMode` is set to `MANUAL`.")
    @JsonProperty(value="queueSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty(value="queueSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public ApplicationConfigUrlConverterWebservice timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Schema(name="Sets a timeout in seconds, that shall be used for the HTTP request to get the URL.")
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public ApplicationConfigUrlConverterWebservice userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Schema(name="Sets the text for the user agent to send to the destination server from which the URL is to be retrieved.")
    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigUrlConverterWebservice applicationConfigUrlConverterWebservice = (ApplicationConfigUrlConverterWebservice)o;
        return Objects.equals(this.enabled, applicationConfigUrlConverterWebservice.enabled) && Objects.equals(this.instances, applicationConfigUrlConverterWebservice.instances) && Objects.equals(this.maxLatency, applicationConfigUrlConverterWebservice.maxLatency) && Objects.equals((Object)this.queueMode, (Object)applicationConfigUrlConverterWebservice.queueMode) && Objects.equals(this.queueSize, applicationConfigUrlConverterWebservice.queueSize) && Objects.equals(this.timeout, applicationConfigUrlConverterWebservice.timeout) && Objects.equals(this.userAgent, applicationConfigUrlConverterWebservice.userAgent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.instances, this.maxLatency, this.queueMode, this.queueSize, this.timeout, this.userAgent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigUrlConverterWebservice {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("    maxLatency: ").append(this.toIndentedString(this.maxLatency)).append("\n");
        sb.append("    queueMode: ").append(this.toIndentedString((Object)this.queueMode)).append("\n");
        sb.append("    queueSize: ").append(this.toIndentedString(this.queueSize)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum QueueModeEnum {
        AUTO(String.valueOf("AUTO")),
        MANUAL(String.valueOf("MANUAL"));

        private String value;

        private QueueModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static QueueModeEnum fromValue(String value) {
            for (QueueModeEnum b : QueueModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

