/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the settings for the registered application on the Microsoft identity platform for access to the SharePoint Online site")
@JsonPropertyOrder(value={"applicationId", "clientSecret", "tenantId"})
@JsonTypeName(value="ApplicationConfig_SharePointBridgeApp")
public class ApplicationConfigSharePointBridgeApp {
    public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
    private String applicationId = "";
    public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
    private String clientSecret = "";
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId = "";

    public ApplicationConfigSharePointBridgeApp applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Schema(name="The ID of the application that was assigned during creation")
    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ApplicationConfigSharePointBridgeApp clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Schema(name="The secret that was generated for the application")
    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public ApplicationConfigSharePointBridgeApp tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="The id of the tenant to which the application belongs")
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigSharePointBridgeApp applicationConfigSharePointBridgeApp = (ApplicationConfigSharePointBridgeApp)o;
        return Objects.equals(this.applicationId, applicationConfigSharePointBridgeApp.applicationId) && Objects.equals(this.clientSecret, applicationConfigSharePointBridgeApp.clientSecret) && Objects.equals(this.tenantId, applicationConfigSharePointBridgeApp.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.clientSecret, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigSharePointBridgeApp {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

