/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AdminExecutableStatus;
import net.webpdf.wsclient.openapi.AdminServerState;
import net.webpdf.wsclient.openapi.WebserviceStatus;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides information about the status and availability of a webservice.")
@JsonPropertyOrder(value={"enabled", "executables", "state", "status"})
@JsonTypeName(value="Admin_WebserviceStatus")
public class AdminWebserviceStatus {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_EXECUTABLES = "executables";
    private Map<String, AdminExecutableStatus> executables = null;
    public static final String JSON_PROPERTY_STATE = "state";
    private AdminServerState state;
    public static final String JSON_PROPERTY_STATUS = "status";
    private WebserviceStatus status = WebserviceStatus.UNKNOWN;

    public AdminWebserviceStatus enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="When set to true, the webservice is enabled and may be used.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AdminWebserviceStatus executables(Map<String, AdminExecutableStatus> executables) {
        this.executables = executables;
        return this;
    }

    public AdminWebserviceStatus putexecutablesItem(String key, AdminExecutableStatus executablesItem) {
        if (this.executables == null) {
            this.executables = new HashMap<String, AdminExecutableStatus>();
        }
        this.executables.put(key, executablesItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="executables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Map<String, AdminExecutableStatus> getExecutables() {
        return this.executables;
    }

    @JsonProperty(value="executables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutables(Map<String, AdminExecutableStatus> executables) {
        this.executables = executables;
    }

    public AdminWebserviceStatus state(AdminServerState state) {
        this.state = state;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminServerState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(AdminServerState state) {
        this.state = state;
    }

    public AdminWebserviceStatus status(WebserviceStatus status) {
        this.status = status;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WebserviceStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(WebserviceStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminWebserviceStatus adminWebserviceStatus = (AdminWebserviceStatus)o;
        return Objects.equals(this.enabled, adminWebserviceStatus.enabled) && Objects.equals(this.executables, adminWebserviceStatus.executables) && Objects.equals(this.state, adminWebserviceStatus.state) && Objects.equals((Object)this.status, (Object)adminWebserviceStatus.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.executables, this.state, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminWebserviceStatus {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    executables: ").append(this.toIndentedString(this.executables)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

