/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.CertificateEntry;
import org.jetbrains.annotations.Nullable;

@Schema(description="Lists all contents of the keystore (e.g. it\u00b4s certificates and raw data), that shall be set as the server\u00b4s truststore.")
@JsonPropertyOrder(value={"certificates", "keyStoreContent"})
@JsonTypeName(value="Admin_TrustStoreKeyStore")
public class AdminTrustStoreKeyStore {
    public static final String JSON_PROPERTY_CERTIFICATES = "certificates";
    private List<CertificateEntry> certificates = null;
    public static final String JSON_PROPERTY_KEY_STORE_CONTENT = "keyStoreContent";
    private String keyStoreContent = "";

    public AdminTrustStoreKeyStore certificates(List<CertificateEntry> certificates) {
        this.certificates = certificates;
        return this;
    }

    public AdminTrustStoreKeyStore addCertificatesItem(CertificateEntry certificatesItem) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<CertificateEntry>();
        }
        this.certificates.add(certificatesItem);
        return this;
    }

    @Schema(name="Defines the certificates contained in the keystore.")
    @JsonProperty(value="certificates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<CertificateEntry> getCertificates() {
        return this.certificates;
    }

    @JsonProperty(value="certificates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertificates(List<CertificateEntry> certificates) {
        this.certificates = certificates;
    }

    public AdminTrustStoreKeyStore keyStoreContent(String keyStoreContent) {
        this.keyStoreContent = keyStoreContent;
        return this;
    }

    @Schema(name="The raw BASE64 encoded contents of a keystore file.")
    @JsonProperty(value="keyStoreContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getKeyStoreContent() {
        return this.keyStoreContent;
    }

    @JsonProperty(value="keyStoreContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyStoreContent(String keyStoreContent) {
        this.keyStoreContent = keyStoreContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminTrustStoreKeyStore adminTrustStoreKeyStore = (AdminTrustStoreKeyStore)o;
        return Objects.equals(this.certificates, adminTrustStoreKeyStore.certificates) && Objects.equals(this.keyStoreContent, adminTrustStoreKeyStore.keyStoreContent);
    }

    public int hashCode() {
        return Objects.hash(this.certificates, this.keyStoreContent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminTrustStoreKeyStore {\n");
        sb.append("    certificates: ").append(this.toIndentedString(this.certificates)).append("\n");
        sb.append("    keyStoreContent: ").append(this.toIndentedString(this.keyStoreContent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

