/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AdminProviderEntry;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains the list of available providers for storing documents, files and sessions in a cluster")
@JsonPropertyOrder(value={"documentStorage", "fileStorage", "sessionStorage"})
@JsonTypeName(value="Admin_Providers")
public class AdminProviders {
    public static final String JSON_PROPERTY_DOCUMENT_STORAGE = "documentStorage";
    private List<AdminProviderEntry> documentStorage = null;
    public static final String JSON_PROPERTY_FILE_STORAGE = "fileStorage";
    private List<AdminProviderEntry> fileStorage = null;
    public static final String JSON_PROPERTY_SESSION_STORAGE = "sessionStorage";
    private List<AdminProviderEntry> sessionStorage = null;

    public AdminProviders documentStorage(List<AdminProviderEntry> documentStorage) {
        this.documentStorage = documentStorage;
        return this;
    }

    public AdminProviders addDocumentStorageItem(AdminProviderEntry documentStorageItem) {
        if (this.documentStorage == null) {
            this.documentStorage = new ArrayList<AdminProviderEntry>();
        }
        this.documentStorage.add(documentStorageItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="documentStorage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<AdminProviderEntry> getDocumentStorage() {
        return this.documentStorage;
    }

    @JsonProperty(value="documentStorage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentStorage(List<AdminProviderEntry> documentStorage) {
        this.documentStorage = documentStorage;
    }

    public AdminProviders fileStorage(List<AdminProviderEntry> fileStorage) {
        this.fileStorage = fileStorage;
        return this;
    }

    public AdminProviders addFileStorageItem(AdminProviderEntry fileStorageItem) {
        if (this.fileStorage == null) {
            this.fileStorage = new ArrayList<AdminProviderEntry>();
        }
        this.fileStorage.add(fileStorageItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="fileStorage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<AdminProviderEntry> getFileStorage() {
        return this.fileStorage;
    }

    @JsonProperty(value="fileStorage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileStorage(List<AdminProviderEntry> fileStorage) {
        this.fileStorage = fileStorage;
    }

    public AdminProviders sessionStorage(List<AdminProviderEntry> sessionStorage) {
        this.sessionStorage = sessionStorage;
        return this;
    }

    public AdminProviders addSessionStorageItem(AdminProviderEntry sessionStorageItem) {
        if (this.sessionStorage == null) {
            this.sessionStorage = new ArrayList<AdminProviderEntry>();
        }
        this.sessionStorage.add(sessionStorageItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="sessionStorage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<AdminProviderEntry> getSessionStorage() {
        return this.sessionStorage;
    }

    @JsonProperty(value="sessionStorage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionStorage(List<AdminProviderEntry> sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminProviders adminProviders = (AdminProviders)o;
        return Objects.equals(this.documentStorage, adminProviders.documentStorage) && Objects.equals(this.fileStorage, adminProviders.fileStorage) && Objects.equals(this.sessionStorage, adminProviders.sessionStorage);
    }

    public int hashCode() {
        return Objects.hash(this.documentStorage, this.fileStorage, this.sessionStorage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminProviders {\n");
        sb.append("    documentStorage: ").append(this.toIndentedString(this.documentStorage)).append("\n");
        sb.append("    fileStorage: ").append(this.toIndentedString(this.fileStorage)).append("\n");
        sb.append("    sessionStorage: ").append(this.toIndentedString(this.sessionStorage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

